/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.primordialharvest.common.impl.entity.ai;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AvoidBlockGoal
extends Goal {
    private final PathfinderMob mob;
    protected final PathNavigation pathNav;
    private final Predicate<BlockState> shouldAvoid;
    private final int distance;
    @Nullable
    private Vec3 toAvoid;
    @Nullable
    private Path escapePath;

    public AvoidBlockGoal(PathfinderMob mob, Predicate<BlockState> shouldAvoid, int distance) {
        this.mob = mob;
        this.pathNav = mob.getNavigation();
        this.shouldAvoid = shouldAvoid;
        this.distance = distance;
    }

    public boolean canUse() {
        Vec3 destination;
        this.toAvoid = BlockPos.findClosestMatch((BlockPos)this.mob.blockPosition(), (int)this.distance, (int)this.distance, p -> this.shouldAvoid.test(this.mob.level().getBlockState(p))).map(BlockPos::getCenter).orElse(null);
        if (this.toAvoid != null && (destination = DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)this.toAvoid)) != null && this.toAvoid.distanceToSqr(destination) > this.mob.distanceToSqr(this.toAvoid)) {
            this.escapePath = this.pathNav.createPath(destination.x, destination.y, destination.z, 0);
            return this.escapePath != null;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.pathNav.isDone();
    }

    public void start() {
        this.pathNav.moveTo(this.escapePath, 1.5);
        this.mob.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 1));
    }

    public void stop() {
        this.toAvoid = null;
    }

    public void tick() {
        this.mob.getNavigation().setSpeedModifier(1.5);
        this.mob.setTarget(null);
    }
}

