/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.primordialharvest.common.impl.blocks;

import net.darkhax.primordialharvest.common.impl.Content;
import net.darkhax.primordialharvest.common.impl.Helper;
import net.darkhax.primordialharvest.common.impl.PrimordialHarvest;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class RumblepeaBlock
extends CropBlock {
    public static final ResourceKey<LootTable> HARVEST_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)PrimordialHarvest.id("gameplay/harvest_rumblepea"));
    private static final VoxelShape SHAPE_STAGE_ZERO = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    private static final VoxelShape SHAPE_STAGE_ONE = Block.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)9.0, (double)12.5);
    private static final VoxelShape SHAPE_STAGE_TWO = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_STAGE_THREE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{SHAPE_STAGE_ZERO, SHAPE_STAGE_ONE, SHAPE_STAGE_ONE, SHAPE_STAGE_TWO, SHAPE_STAGE_TWO, SHAPE_STAGE_THREE, SHAPE_STAGE_THREE, SHAPE_STAGE_THREE};

    public RumblepeaBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY));
    }

    @NotNull
    public ItemLike getBaseSeedId() {
        return (ItemLike)Content.RUMBLEPEA_SEED.get();
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    protected boolean isRandomlyTicking(@NotNull BlockState state) {
        return true;
    }

    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (this.isMaxAge(state)) {
            Helper.dropLoot(level, pos, HARVEST_TABLE, player, ItemStack.EMPTY);
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState newBlock = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(4));
            level.setBlock(pos, newBlock, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newBlock));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected void randomTick(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (level.getRawBrightness(pos, 0) >= 9) {
            int currentAge = this.getAge(state);
            if (currentAge < this.getMaxAge()) {
                if (random.nextInt((int)(25.0f / ((Float)Helper.GET_GROWTH_SPEED.apply((Object)state, (Object)level, (Object)pos)).floatValue()) + 1) == 0) {
                    level.setBlock(pos, this.getStateForAge(currentAge + 1), 2);
                }
            } else {
                for (BlockPos neighbor : BlockPos.withinManhattan((BlockPos)pos, (int)1, (int)1, (int)1)) {
                    BonemealableBlock bonemealable;
                    Block block;
                    if (neighbor.equals((Object)pos)) continue;
                    BlockState neighborState = level.getBlockState(neighbor);
                    if (!(random.nextFloat() < 0.5f) || !((block = neighborState.getBlock()) instanceof BonemealableBlock) || !(bonemealable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, neighbor, neighborState)) continue;
                    if (bonemealable.isBonemealSuccess((Level)level, random, neighbor, neighborState)) {
                        bonemealable.performBonemeal(level, random, neighbor, neighborState);
                    }
                    level.levelEvent(1505, neighbor, 15);
                }
            }
        }
    }

    public static void trampled(Level level, BlockPos pos) {
        level.explode(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 3.0f, Level.ExplosionInteraction.BLOCK);
    }
}

