/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.primordialharvest.common.impl.blocks;

import net.darkhax.primordialharvest.common.impl.Content;
import net.darkhax.primordialharvest.common.impl.Helper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class BloodCauldronBlock
extends LayeredCauldronBlock {
    private static final BlockBehaviour.Properties PROPERTIES = BlockBehaviour.Properties.of().mapColor(MapColor.STONE).requiresCorrectToolForDrops().strength(2.0f).noOcclusion();

    public BloodCauldronBlock() {
        super(Biome.Precipitation.NONE, Content.INTERACTIONS, PROPERTIES);
    }

    protected boolean canReceiveStalactiteDrip(@NotNull Fluid fluid) {
        return false;
    }

    protected void receiveStalactiteDrip(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Fluid fluid) {
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (!level.isClientSide && entity instanceof ItemEntity) {
            CauldronInteraction interaction;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (this.isEntityInsideContent(state, pos, entity) && (interaction = (CauldronInteraction)this.interactions.map().get(itemEntity.getItem().getItem())) != null && interaction.interact(state, level, pos, null, null, itemEntity.getItem()).consumesAction()) {
                Helper.shrink(itemEntity);
                BloodCauldronBlock.lowerFillLevel((BlockState)state, (Level)level, (BlockPos)pos);
            }
        }
    }

    public void handlePrecipitation(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Biome.Precipitation precipitation) {
    }
}

