/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.primordialharvest.common.impl.blocks;

import net.darkhax.primordialharvest.common.impl.Content;
import net.darkhax.primordialharvest.common.impl.Helper;
import net.darkhax.primordialharvest.common.impl.PrimordialHarvest;
import net.darkhax.primordialharvest.common.mixin.AccessorCropBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpireshuckBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final ResourceKey<LootTable> HARVEST_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)PrimordialHarvest.id("gameplay/harvest_spireshuck"));
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    private static final VoxelShape FULL_UPPER_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private static final VoxelShape FULL_LOWER_SHAPE = Block.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape COLLISION_SHAPE_BULB = Block.box((double)5.0, (double)-1.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
    private static final VoxelShape[] UPPER_SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), FULL_UPPER_SHAPE};
    private static final VoxelShape[] LOWER_SHAPE_BY_AGE = new VoxelShape[]{COLLISION_SHAPE_BULB, Block.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), FULL_LOWER_SHAPE, FULL_LOWER_SHAPE, FULL_LOWER_SHAPE};

    public SpireshuckBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).forceSolidOff().noCollission().randomTicks().instabreak().sound(SoundType.HARD_CROP).pushReaction(PushReaction.DESTROY));
    }

    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (!this.isLower(state) && SpireshuckBlock.isMaxAge(state)) {
            Helper.dropLoot(level, pos, HARVEST_TABLE, player, ItemStack.EMPTY);
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState newBlock = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(3));
            level.setBlock(pos, newBlock, 2);
            BlockState below = level.getBlockState(pos.below());
            if (this.isLower(below)) {
                level.setBlock(pos.below(), (BlockState)below.setValue((Property)AGE, (Comparable)Integer.valueOf(3)), 2);
            }
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newBlock));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return this.defaultBlockState();
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            return UPPER_SHAPE_BY_AGE[Math.min(Math.abs(4 - ((Integer)state.getValue((Property)AGE) + 1)), UPPER_SHAPE_BY_AGE.length - 1)];
        }
        return LOWER_SHAPE_BY_AGE[(Integer)state.getValue((Property)AGE)];
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext entContext;
        return context instanceof EntityCollisionContext && (entContext = (EntityCollisionContext)context).getEntity() instanceof Player ? Shapes.empty() : this.getShape(state, level, pos, context);
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        return SpireshuckBlock.isDouble((Integer)state.getValue((Property)AGE)) ? super.updateShape(state, facing, facingState, level, currentPos, facingPos) : (state.canSurvive((LevelReader)level, currentPos) ? state : Blocks.AIR.defaultBlockState());
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return this.isLower(state) && !SpireshuckBlock.sufficientLight(level, pos) ? false : super.canSurvive(state, level, pos);
    }

    protected boolean mayPlaceOn(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.is(Blocks.FARMLAND);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
        super.createBlockStateDefinition(builder);
    }

    public boolean canBeReplaced(@NotNull BlockState state, @NotNull BlockPlaceContext useContext) {
        return false;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull LivingEntity placer, @NotNull ItemStack stack) {
    }

    public boolean isRandomlyTicking(BlockState state) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && !SpireshuckBlock.isMaxAge(state);
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, RandomSource random) {
        if (random.nextInt((int)(25.0f / ((Float)Helper.GET_GROWTH_SPEED.apply((Object)state, (Object)level, (Object)pos)).floatValue()) + 1) == 0) {
            this.grow(level, state, pos, 1);
        }
    }

    private void grow(ServerLevel level, BlockState state, BlockPos pos, int ageIncrement) {
        int growthAmount = Math.min((Integer)state.getValue((Property)AGE) + ageIncrement, 4);
        if (this.canGrow((LevelReader)level, pos, state, growthAmount)) {
            BlockState newState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(growthAmount));
            level.setBlock(pos, newState, 2);
            if (SpireshuckBlock.isDouble(growthAmount)) {
                level.setBlock(pos.above(), (BlockState)newState.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
            }
        }
    }

    private boolean canGrowInto(LevelReader level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.isAir() || state.is((Block)this);
    }

    private static boolean sufficientLight(LevelReader level, BlockPos pos) {
        return AccessorCropBlock.hasSufficientLight(level, pos);
    }

    private boolean isLower(BlockState state) {
        return state.is((Block)this) && state.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    private static boolean isDouble(int age) {
        return age >= 3;
    }

    private boolean canGrow(LevelReader reader, BlockPos pos, BlockState state, int age) {
        return !SpireshuckBlock.isMaxAge(state) && SpireshuckBlock.sufficientLight(reader, pos) && (!SpireshuckBlock.isDouble(age) || this.canGrowInto(reader, pos.above()));
    }

    public static boolean isMaxAge(BlockState state) {
        return (Integer)state.getValue((Property)AGE) >= 4;
    }

    public static boolean repelsMobs(BlockState state) {
        return state.is(Content.SPIRESHUCK_BLOCK.get()) && SpireshuckBlock.isMaxAge(state);
    }

    @Nullable
    private Tuple<BlockPos, BlockState> getLowerHalf(LevelReader level, BlockPos pos, BlockState state) {
        if (!this.isLower(state)) {
            BlockPos below = pos.below();
            BlockState belowState = level.getBlockState(below);
            return this.isLower(belowState) ? new Tuple((Object)below, (Object)belowState) : null;
        }
        return new Tuple((Object)pos, (Object)state);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Tuple<BlockPos, BlockState> lowerHalf = this.getLowerHalf(level, pos, state);
        return lowerHalf != null && this.canGrow(level, (BlockPos)lowerHalf.getA(), (BlockState)lowerHalf.getB(), (Integer)((BlockState)lowerHalf.getB()).getValue((Property)AGE) + 1);
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Tuple<BlockPos, BlockState> lower = this.getLowerHalf((LevelReader)level, pos, state);
        if (lower != null) {
            this.grow(level, (BlockState)lower.getB(), (BlockPos)lower.getA(), 1);
        }
    }
}

