/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.primordialharvest.common.impl;

import java.util.List;
import net.darkhax.primordialharvest.common.impl.Content;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;

public class Helper {
    private static final AABB INSIDE_CAULDRON = (AABB)Block.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0).toAabbs().getFirst();

    public static void dropLoot(Level level, BlockPos pos, ResourceKey<LootTable> tableId, Player player, ItemStack tool) {
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.BLOCK_STATE, (Object)level.getBlockState(pos)).withParameter(LootContextParams.ORIGIN, (Object)pos.getCenter()).withParameter(LootContextParams.TOOL, (Object)tool).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withLuck(player.getLuck()).create(LootContextParamSets.BLOCK);
            LootTable table = level.getServer().reloadableRegistries().getLootTable(tableId);
            for (ItemStack stack : table.getRandomItems(params)) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
            }
        }
    }

    public static void shrink(ItemEntity entity) {
        entity.getItem().shrink(1);
        if (entity.getItem().isEmpty()) {
            entity.discard();
        }
    }

    public static void checkReagents(ItemEntity entity) {
        if (entity.getItem().is(Content.PHILOSOPHER_REAGENTS)) {
            List items;
            int level;
            BlockPos position = entity.blockPosition();
            BlockState container = entity.level().getBlockState(position);
            if (container.is(Blocks.WATER_CAULDRON) && (level = ((Integer)container.getValue((Property)BlockStateProperties.LEVEL_CAULDRON)).intValue()) > 0 && (items = entity.level().getEntitiesOfClass(ItemEntity.class, new AABB(position), EntitySelector.ENTITY_STILL_ALIVE)).size() >= 3) {
                ItemEntity sulfur = null;
                ItemEntity mercury = null;
                ItemEntity salt = null;
                for (ItemEntity item : items) {
                    if (sulfur != null && mercury != null && salt != null) break;
                    ItemStack stack = item.getItem();
                    if (sulfur == null && stack.is(Content.RUMBLEPEA_FRUIT.get())) {
                        sulfur = item;
                        continue;
                    }
                    if (mercury == null && stack.is(Content.SPIRESHUCK_FRUIT.get())) {
                        mercury = item;
                        continue;
                    }
                    if (salt != null || !stack.is(Content.PALEOGOURD_FRUIT.get())) continue;
                    salt = item;
                }
                if (sulfur != null && mercury != null && salt != null) {
                    Helper.shrink(sulfur);
                    Helper.shrink(mercury);
                    Helper.shrink(salt);
                    entity.level().setBlock(position, (BlockState)Content.BLOOD_CAULDRON_BLOCK.get().defaultBlockState().setValue((Property)BlockStateProperties.LEVEL_CAULDRON, (Comparable)Integer.valueOf(level)), 2);
                }
            }
        }
    }
}

