/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.primordialharvest.common.impl;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.loot.PoolTarget;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.registry.IContentProvider;
import net.darkhax.bookshelf.common.api.registry.register.Register;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItem;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItemTab;
import net.darkhax.bookshelf.common.api.registry.register.RegisterLootPoolAdditions;
import net.darkhax.primordialharvest.common.impl.PrimordialHarvest;
import net.darkhax.primordialharvest.common.impl.blocks.BloodCauldronBlock;
import net.darkhax.primordialharvest.common.impl.blocks.PaleogourdBlock;
import net.darkhax.primordialharvest.common.impl.blocks.RumblepeaBlock;
import net.darkhax.primordialharvest.common.impl.blocks.SpireshuckBlock;
import net.darkhax.primordialharvest.common.impl.item.RumblepeaFruitItem;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class Content
implements IContentProvider {
    public static final ResourceLocation PALEOGOURD_BLOCK_ID = PrimordialHarvest.id("paleogourd");
    public static final Supplier<Block> PALEOGOURD_BLOCK = CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)PALEOGOURD_BLOCK_ID);
    public static final ResourceLocation PALEOGOURD_SEED_ID = PrimordialHarvest.id("paleogourd_seeds");
    public static final Supplier<Item> PALEOGOURD_SEED = CachedSupplier.of((Registry)BuiltInRegistries.ITEM, (ResourceLocation)PALEOGOURD_SEED_ID);
    public static final ResourceLocation PALEOGOURD_FRUIT_ID = PrimordialHarvest.id("paleogourd");
    public static final Supplier<Item> PALEOGOURD_FRUIT = CachedSupplier.of((Registry)BuiltInRegistries.ITEM, (ResourceLocation)PALEOGOURD_FRUIT_ID);
    public static final ResourceLocation SPIRESHUCK_BLOCK_ID = PrimordialHarvest.id("spireshuck");
    public static final Supplier<Block> SPIRESHUCK_BLOCK = CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)SPIRESHUCK_BLOCK_ID);
    public static final ResourceLocation SPIRESHUCK_SEED_ID = PrimordialHarvest.id("spireshuck_seeds");
    public static final Supplier<Item> SPIRESHUCK_SEED = CachedSupplier.of((Registry)BuiltInRegistries.ITEM, (ResourceLocation)SPIRESHUCK_SEED_ID);
    public static final ResourceLocation SPIRESHUCK_FRUIT_ID = PrimordialHarvest.id("spireshuck");
    public static final Supplier<Item> SPIRESHUCK_FRUIT = CachedSupplier.of((Registry)BuiltInRegistries.ITEM, (ResourceLocation)SPIRESHUCK_FRUIT_ID);
    public static final ResourceLocation RUMBLEPEA_BLOCK_ID = PrimordialHarvest.id("rumblepea");
    public static final Supplier<Block> RUMBLEPEA_BLOCK = CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)RUMBLEPEA_BLOCK_ID);
    public static final ResourceLocation RUMBLEPEA_SEED_ID = PrimordialHarvest.id("rumblepea_seeds");
    public static final Supplier<Item> RUMBLEPEA_SEED = CachedSupplier.of((Registry)BuiltInRegistries.ITEM, (ResourceLocation)RUMBLEPEA_SEED_ID);
    public static final ResourceLocation RUMBLEPEA_FRUIT_ID = PrimordialHarvest.id("rumblepea");
    public static final Supplier<Item> RUMBLEPEA_FRUIT = CachedSupplier.of((Registry)BuiltInRegistries.ITEM, (ResourceLocation)RUMBLEPEA_FRUIT_ID);
    public static final ResourceLocation BLOOD_CAULDRON_BLOCK_ID = PrimordialHarvest.id("blood_cauldron");
    public static final CauldronInteraction.InteractionMap INTERACTIONS = CauldronInteraction.newInteractionMap((String)BLOOD_CAULDRON_BLOCK_ID.toString());
    public static final Supplier<Block> BLOOD_CAULDRON_BLOCK = CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)BLOOD_CAULDRON_BLOCK_ID);
    public static final TagKey<Item> PHILOSOPHER_REAGENTS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)PrimordialHarvest.id("philosopher_reagents"));

    public String contentNamespace() {
        return "primordial_harvest";
    }

    public void registerItemTabs(RegisterItemTab registry) {
        registry.add("items", () -> PALEOGOURD_FRUIT.get().getDefaultInstance(), (params, out) -> {
            out.accept((ItemLike)PALEOGOURD_SEED.get());
            out.accept((ItemLike)PALEOGOURD_FRUIT.get());
            out.accept((ItemLike)SPIRESHUCK_SEED.get());
            out.accept((ItemLike)SPIRESHUCK_FRUIT.get());
            out.accept((ItemLike)RUMBLEPEA_SEED.get());
            out.accept((ItemLike)RUMBLEPEA_FRUIT.get());
        });
    }

    public void registerBlocks(Register<Block> registry) {
        registry.add(PALEOGOURD_BLOCK_ID, (Object)new PaleogourdBlock());
        registry.add(SPIRESHUCK_BLOCK_ID, (Object)new SpireshuckBlock());
        registry.add(RUMBLEPEA_BLOCK_ID, (Object)new RumblepeaBlock());
        registry.add(BLOOD_CAULDRON_BLOCK_ID, (Object)new BloodCauldronBlock());
    }

    public void registerItems(RegisterItem registry) {
        registry.add(PALEOGOURD_SEED_ID, (Item)new ItemNameBlockItem(PALEOGOURD_BLOCK.get(), new Item.Properties()));
        registry.add(PALEOGOURD_FRUIT_ID, new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.6f).effect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300), 0.1f).build())));
        registry.add(SPIRESHUCK_SEED_ID, (Item)new ItemNameBlockItem(SPIRESHUCK_BLOCK.get(), new Item.Properties()));
        registry.add(SPIRESHUCK_FRUIT_ID, (Item)new RumblepeaFruitItem(new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.2f).build())));
        registry.add(RUMBLEPEA_SEED_ID, (Item)new ItemNameBlockItem(RUMBLEPEA_BLOCK.get(), new Item.Properties()));
        registry.add(RUMBLEPEA_FRUIT_ID, (Item)new RumblepeaFruitItem(new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.4f).build())));
        Content.addBloodRecipe(Items.COPPER_INGOT, new ItemStack((ItemLike)Items.GOLD_INGOT));
    }

    public void registerPotions(Register<Potion> registry) {
        registry.add("primordial_harvest.resistance", (Object)new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1800)}));
        registry.add("primordial_harvest.long_resistance", (Object)new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 4800)}));
        registry.add("primordial_harvest.strong_resistance", (Object)new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1800, 1)}));
    }

    public void registerBrewing(PotionBrewing.Builder registry) {
        Holder.Reference resistance = BuiltInRegistries.POTION.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.POTION, (ResourceLocation)PrimordialHarvest.id("primordial_harvest.resistance")));
        Holder.Reference long_resistance = BuiltInRegistries.POTION.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.POTION, (ResourceLocation)PrimordialHarvest.id("primordial_harvest.long_resistance")));
        Holder.Reference strong_resistance = BuiltInRegistries.POTION.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.POTION, (ResourceLocation)PrimordialHarvest.id("primordial_harvest.strong_resistance")));
        registry.addStartMix(PALEOGOURD_FRUIT.get(), (Holder)resistance);
        registry.addMix((Holder)resistance, Items.REDSTONE, (Holder)long_resistance);
        registry.addMix((Holder)resistance, Items.GLOWSTONE_DUST, (Holder)strong_resistance);
        registry.addStartMix(SPIRESHUCK_FRUIT.get(), Potions.WEAKNESS);
    }

    public void registerLootPoolAdditions(RegisterLootPoolAdditions registry) {
        registry.add(PALEOGOURD_SEED_ID.getPath(), PoolTarget.SNIFFER_DIGGING, PALEOGOURD_SEED.get(), 1);
        registry.add(SPIRESHUCK_SEED_ID.getPath(), PoolTarget.SNIFFER_DIGGING, SPIRESHUCK_SEED.get(), 1);
        registry.add(RUMBLEPEA_SEED_ID.getPath(), PoolTarget.SNIFFER_DIGGING, RUMBLEPEA_SEED.get(), 1);
    }

    public void bindRenderLayers(BiConsumer<Block, RenderType> registry) {
        registry.accept(PALEOGOURD_BLOCK.get(), RenderType.cutout());
        registry.accept(SPIRESHUCK_BLOCK.get(), RenderType.cutout());
        registry.accept(RUMBLEPEA_BLOCK.get(), RenderType.cutout());
        registry.accept(BLOOD_CAULDRON_BLOCK.get(), RenderType.cutout());
    }

    public static void addBloodRecipe(Item input, ItemStack output) {
        INTERACTIONS.map().put(input, (state, level, pos, player, hand, inputStack) -> {
            if (!level.isClientSide) {
                if (player != null) {
                    player.awardStat(Stats.USE_CAULDRON);
                    player.awardStat(Stats.ITEM_USED.get((Object)inputStack.getItem()));
                }
                inputStack.shrink(1);
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)output.copy());
                LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)level, (BlockPos)pos);
                level.playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.SPLASH, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
    }
}

