package net.darkhax.primordialharvest.common.impl;

import net.darkhax.bookshelf.common.api.data.loot.PoolTarget;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.registry.ContentProvider;
import net.darkhax.bookshelf.common.api.registry.adapters.GameRegistryAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRegistryAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRenderTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.CreativeModeTabAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.LootPoolAdditionAdapter;
import net.darkhax.primordialharvest.common.impl.blocks.BloodCauldronBlock;
import net.darkhax.primordialharvest.common.impl.blocks.PaleogourdBlock;
import net.darkhax.primordialharvest.common.impl.blocks.RumblepeaBlock;
import net.darkhax.primordialharvest.common.impl.blocks.SpireshuckBlock;
import net.darkhax.primordialharvest.common.impl.item.RumblepeaFruitItem;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_1798;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9062;
import java.util.function.Supplier;

public class Content implements ContentProvider {

    public static final class_2960 PALEOGOURD_BLOCK_ID = PrimordialHarvest.id("paleogourd");
    public static final Supplier<class_2248> PALEOGOURD_BLOCK = CachedSupplier.of(class_7923.field_41175, PALEOGOURD_BLOCK_ID);
    public static final class_2960 PALEOGOURD_SEED_ID = PrimordialHarvest.id("paleogourd_seeds");
    public static final Supplier<class_1792> PALEOGOURD_SEED = CachedSupplier.of(class_7923.field_41178, PALEOGOURD_SEED_ID);
    public static final class_2960 PALEOGOURD_FRUIT_ID = PrimordialHarvest.id("paleogourd");
    public static final Supplier<class_1792> PALEOGOURD_FRUIT = CachedSupplier.of(class_7923.field_41178, PALEOGOURD_FRUIT_ID);

    public static final class_2960 SPIRESHUCK_BLOCK_ID = PrimordialHarvest.id("spireshuck");
    public static final Supplier<class_2248> SPIRESHUCK_BLOCK = CachedSupplier.of(class_7923.field_41175, SPIRESHUCK_BLOCK_ID);
    public static final class_2960 SPIRESHUCK_SEED_ID = PrimordialHarvest.id("spireshuck_seeds");
    public static final Supplier<class_1792> SPIRESHUCK_SEED = CachedSupplier.of(class_7923.field_41178, SPIRESHUCK_SEED_ID);
    public static final class_2960 SPIRESHUCK_FRUIT_ID = PrimordialHarvest.id("spireshuck");
    public static final Supplier<class_1792> SPIRESHUCK_FRUIT = CachedSupplier.of(class_7923.field_41178, SPIRESHUCK_FRUIT_ID);

    public static final class_2960 RUMBLEPEA_BLOCK_ID = PrimordialHarvest.id("rumblepea");
    public static final Supplier<class_2248> RUMBLEPEA_BLOCK = CachedSupplier.of(class_7923.field_41175, RUMBLEPEA_BLOCK_ID);
    public static final class_2960 RUMBLEPEA_SEED_ID = PrimordialHarvest.id("rumblepea_seeds");
    public static final Supplier<class_1792> RUMBLEPEA_SEED = CachedSupplier.of(class_7923.field_41178, RUMBLEPEA_SEED_ID);
    public static final class_2960 RUMBLEPEA_FRUIT_ID = PrimordialHarvest.id("rumblepea");
    public static final Supplier<class_1792> RUMBLEPEA_FRUIT = CachedSupplier.of(class_7923.field_41178, RUMBLEPEA_FRUIT_ID);

    public static final class_2960 BLOOD_CAULDRON_BLOCK_ID = PrimordialHarvest.id("blood_cauldron");
    public static final class_5620.class_8821 INTERACTIONS = class_5620.method_32206(Content.BLOOD_CAULDRON_BLOCK_ID.toString());
    public static final Supplier<class_2248> BLOOD_CAULDRON_BLOCK = CachedSupplier.of(class_7923.field_41175, BLOOD_CAULDRON_BLOCK_ID);

    public static final class_6862<class_1792> PHILOSOPHER_REAGENTS = class_6862.method_40092(class_7924.field_41197, PrimordialHarvest.id("philosopher_reagents"));

    @Override
    public String namespace() {
        return PrimordialHarvest.MOD_ID;
    }

    @Override
    public void defineCreativeTabs(CreativeModeTabAdapter registry) {
        registry.add("items", () -> PALEOGOURD_FRUIT.get().method_7854(), (params, out) -> {
            out.method_45421(PALEOGOURD_SEED.get());
            out.method_45421(PALEOGOURD_FRUIT.get());
            out.method_45421(SPIRESHUCK_SEED.get());
            out.method_45421(SPIRESHUCK_FRUIT.get());
            out.method_45421(RUMBLEPEA_SEED.get());
            out.method_45421(RUMBLEPEA_FRUIT.get());
        });
    }

    @Override
    public void defineBlocks(BlockRegistryAdapter registry) {
        registry.add(PALEOGOURD_BLOCK_ID.method_12832(), new PaleogourdBlock());
        registry.add(SPIRESHUCK_BLOCK_ID.method_12832(), new SpireshuckBlock());
        registry.add(RUMBLEPEA_BLOCK_ID.method_12832(), new RumblepeaBlock());
        registry.add(BLOOD_CAULDRON_BLOCK_ID.method_12832(), new BloodCauldronBlock());
    }

    @Override
    public void defineItems(GameRegistryAdapter<class_1792> registry) {
        registry.add(PALEOGOURD_SEED_ID.method_12832(), new class_1798(PALEOGOURD_BLOCK.get(), new class_1792.class_1793()));
        registry.add(PALEOGOURD_FRUIT_ID.method_12832(), new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(2).method_19237(0.6f).method_19239(new class_1293(class_1294.field_5907, 300), 0.1f).method_19242())));
        registry.add(SPIRESHUCK_SEED_ID.method_12832(), new class_1798(SPIRESHUCK_BLOCK.get(), new class_1792.class_1793()));
        registry.add(SPIRESHUCK_FRUIT_ID.method_12832(), new RumblepeaFruitItem(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(2).method_19237(0.2f).method_19242())));
        registry.add(RUMBLEPEA_SEED_ID.method_12832(), new class_1798(RUMBLEPEA_BLOCK.get(), new class_1792.class_1793()));
        registry.add(RUMBLEPEA_FRUIT_ID.method_12832(), new RumblepeaFruitItem(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(2).method_19237(0.4f).method_19242())));
        addBloodRecipe(class_1802.field_27022, new class_1799(class_1802.field_8695));
    }

    @Override
    public void definePotions(GameRegistryAdapter<class_1842> registry) {
        registry.add(PrimordialHarvest.MOD_ID + ".resistance", new class_1842(new class_1293(class_1294.field_5907, 1800)));
        registry.add(PrimordialHarvest.MOD_ID + ".long_resistance", new class_1842(new class_1293(class_1294.field_5907, 4800)));
        registry.add(PrimordialHarvest.MOD_ID + ".strong_resistance", new class_1842(new class_1293(class_1294.field_5907, 1800, 1)));
    }

    @Override
    public void defineBrews(class_1845.class_9665 registry) {
        final class_6880<class_1842> resistance = class_7923.field_41179.method_40290(class_5321.method_29179(class_7924.field_41215, PrimordialHarvest.id(PrimordialHarvest.MOD_ID + ".resistance")));
        final class_6880<class_1842> long_resistance = class_7923.field_41179.method_40290(class_5321.method_29179(class_7924.field_41215, PrimordialHarvest.id(PrimordialHarvest.MOD_ID + ".long_resistance")));
        final class_6880<class_1842> strong_resistance = class_7923.field_41179.method_40290(class_5321.method_29179(class_7924.field_41215, PrimordialHarvest.id(PrimordialHarvest.MOD_ID + ".strong_resistance")));
        registry.method_59704(PALEOGOURD_FRUIT.get(), resistance);
        registry.method_59705(resistance, class_1802.field_8725, long_resistance);
        registry.method_59705(resistance, class_1802.field_8601, strong_resistance);
        registry.method_59704(SPIRESHUCK_FRUIT.get(), class_1847.field_8975);
    }

    @Override
    public void defineLootPoolAdditions(LootPoolAdditionAdapter registry) {
        registry.add(PALEOGOURD_SEED_ID.method_12832(), PoolTarget.SNIFFER_DIGGING, PALEOGOURD_SEED.get(), 1);
        registry.add(SPIRESHUCK_SEED_ID.method_12832(), PoolTarget.SNIFFER_DIGGING, SPIRESHUCK_SEED.get(), 1);
        registry.add(RUMBLEPEA_SEED_ID.method_12832(), PoolTarget.SNIFFER_DIGGING, RUMBLEPEA_SEED.get(), 1);
    }

    @Override
    public void defineBlockRenderTypes(BlockRenderTypeAdapter registry) {
        registry.add(PALEOGOURD_BLOCK.get(), class_1921.method_23581());
        registry.add(SPIRESHUCK_BLOCK.get(), class_1921.method_23581());
        registry.add(RUMBLEPEA_BLOCK.get(), class_1921.method_23581());
        registry.add(BLOOD_CAULDRON_BLOCK.get(), class_1921.method_23581());
    }

    public static void addBloodRecipe(class_1792 input, class_1799 output) {
        INTERACTIONS.comp_1982().put(input, (state, level, pos, player, hand, inputStack) -> {
            if (!level.field_9236) {
                if (player != null) {
                    player.method_7281(class_3468.field_15373);
                    player.method_7259(class_3468.field_15372.method_14956(inputStack.method_7909()));
                }
                inputStack.method_7934(1);
                class_2248.method_9577(level, pos, output.method_7972());
                class_5556.method_31650(state, level, pos);
                level.method_8396(null, pos, class_3417.field_14737, class_3419.field_15245, 1f, 1f);
                level.method_33596(null, class_5712.field_28160, pos);
            }
            return class_9062.method_55644(level.field_9236);
        });
    }
}