package net.darkhax.primordialharvest.common.impl.blocks;

import net.darkhax.primordialharvest.common.impl.Content;
import net.darkhax.primordialharvest.common.impl.Helper;
import net.darkhax.primordialharvest.common.impl.PrimordialHarvest;
import net.darkhax.primordialharvest.common.mixin.AccessorCropBlock;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class RumblepeaBlock extends class_2302 {

    public static final class_5321<class_52> HARVEST_TABLE = class_5321.method_29179(class_7924.field_50079, PrimordialHarvest.id("gameplay/harvest_rumblepea"));
    private static final class_265 SHAPE_STAGE_ZERO = class_2248.method_9541(4f, 0f, 4f, 12f, 4f, 12f);
    private static final class_265 SHAPE_STAGE_ONE = class_2248.method_9541(3.5f, 0f, 3.5f, 12.5f, 9f, 12.5f);
    private static final class_265 SHAPE_STAGE_TWO = class_2248.method_9541(1f, 0f, 1f, 15f, 15f, 15f);
    private static final class_265 SHAPE_STAGE_THREE = class_2248.method_9541(1f, 0f, 1f, 15f, 15f, 15f);
    private static final class_265[] SHAPE_BY_AGE = {SHAPE_STAGE_ZERO, SHAPE_STAGE_ONE, SHAPE_STAGE_ONE, SHAPE_STAGE_TWO, SHAPE_STAGE_TWO, SHAPE_STAGE_THREE, SHAPE_STAGE_THREE, SHAPE_STAGE_THREE};

    public RumblepeaBlock() {
        super(class_2251.method_9637().method_31710(class_3620.field_16004).method_9634().method_9640().method_9618().method_9626(class_2498.field_17580).method_50012(class_3619.field_15971));
    }

    @NotNull
    @Override
    public class_1935 method_9832() {
        return Content.RUMBLEPEA_SEED.get();
    }

    @NotNull
    @Override
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return SHAPE_BY_AGE[this.method_9829(state)];
    }

    @Override
    protected boolean method_9542(@NotNull class_2680 state) {
        return true;
    }

    @Override
    protected class_1269 method_55766(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_3965 hitResult) {
        if (method_9825(state)) {
            Helper.dropLoot(level, pos, HARVEST_TABLE, player, class_1799.field_8037);
            level.method_8396(null, pos, class_3417.field_17617, class_3419.field_15245, 1f, 0.8f + level.field_9229.method_43057() * 0.4f);
            final class_2680 newBlock = state.method_11657(field_10835, 4);
            level.method_8652(pos, newBlock, 2);
            level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286(player, newBlock));
            return class_1269.method_29236(level.field_9236);
        }
        return super.method_55766(state, level, pos, player, hitResult);
    }

    @Override
    protected void method_9514(@NotNull class_2680 state, class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (level.method_22335(pos, 0) >= 9) {
            final int currentAge = this.method_9829(state);
            if (currentAge < this.method_9827()) {
                if (random.method_43048((int)(25f / AccessorCropBlock.getGrowthSpeed(this, level, pos)) + 1) == 0) {
                    level.method_8652(pos, this.method_9828(currentAge + 1), 2);
                }
            }
            else {
                for (class_2338 neighbor : class_2338.method_25996(pos, 1, 1, 1)) {
                    if (!neighbor.equals(pos)) {
                        final class_2680 neighborState = level.method_8320(neighbor);
                        if (random.method_43057() < 0.5f && neighborState.method_26204() instanceof class_2256 bonemealable && bonemealable.method_9651(level, neighbor, neighborState)) {
                            if (bonemealable.method_9650(level, random, neighbor, neighborState)) {
                                bonemealable.method_9652(level, random, neighbor, neighborState);
                            }
                            level.method_20290(1505, neighbor, 15);
                        }
                    }
                }
            }
        }
    }

    public static void trampled(class_1937 level, class_2338 pos) {
        level.method_8437(null, pos.method_10263() + 0.5f, pos.method_10264() + 0.5f, pos.method_10260() + 0.5f, 3f, class_1937.class_7867.field_40889);
    }
}