/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.primordialharvest.common.impl.blocks;

import java.util.Optional;
import net.darkhax.primordialharvest.common.impl.Content;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PaleogourdBlock
extends CropBlock {
    private static final VoxelShape SHAPE_STAGE_ZERO = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    private static final VoxelShape SHAPE_STAGE_ONE = Block.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)4.0, (double)12.5);
    private static final VoxelShape SHAPE_STAGE_TWO = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    private static final VoxelShape SHAPE_STAGE_THREE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{SHAPE_STAGE_ZERO, SHAPE_STAGE_ZERO, SHAPE_STAGE_ONE, SHAPE_STAGE_ONE, SHAPE_STAGE_TWO, SHAPE_STAGE_TWO, SHAPE_STAGE_TWO, SHAPE_STAGE_THREE};

    public PaleogourdBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.HARD_CROP).pushReaction(PushReaction.DESTROY));
    }

    @NotNull
    public ItemLike getBaseSeedId() {
        return (ItemLike)Content.PALEOGOURD_SEED.get();
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    public static boolean preventTrampling(Level level, BlockPos farmlandPos) {
        BlockPos above = farmlandPos.above();
        Optional gourdPos = BlockPos.findClosestMatch((BlockPos)above, (int)3, (int)0, p -> {
            BlockState state = level.getBlockState(p);
            return state.is(Content.PALEOGOURD_BLOCK.get()) && (Integer)state.getValue((Property)BlockStateProperties.AGE_7) == 7;
        });
        if (gourdPos.isPresent() || level.getBlockState(above).is(Content.PALEOGOURD_BLOCK.get())) {
            level.playSound(null, farmlandPos, SoundEvents.WOOD_FALL, SoundSource.BLOCKS, 1.0f, 0.0f);
            return true;
        }
        return false;
    }
}

