package net.darkhax.pigpen.common.impl.data.conditions;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.data.conditions.ConditionType;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.data.conditions.LoadConditions;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.pigpen.common.impl.PigPenMod;
import net.minecraft.class_2960;

public class ConfigProperty implements ILoadCondition {

    public static final class_2960 TYPE_ID = PigPenMod.id("config");
    public static final CachedSupplier<ConditionType> TYPE = CachedSupplier.cache(() -> LoadConditions.getType(TYPE_ID));
    public static final MapCodec<ConfigProperty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(MapCodecs.RESOURCE_LOCATION.get("property", ConfigProperty::getProperty)).apply(instance, ConfigProperty::new));

    private final class_2960 property;

    private ConfigProperty(class_2960 property) {
        this.property = property;
    }

    public class_2960 getProperty() {
        return this.property;
    }

    @Override
    public boolean allowLoading() {
        return PigPenMod.PROPERTIES.get().containsKey(this.property) && PigPenMod.PROPERTIES.get().get(this.property).get();
    }

    @Override
    public ConditionType getType() {
        return TYPE.get();
    }
}