/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader.packs;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.darkhax.openloader.Constants;
import net.darkhax.openloader.config.ConfigSchema;
import net.darkhax.openloader.packs.RepoType;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;

public class OpenLoaderRepositorySource
implements RepositorySource {
    private static final PackSource SOURCE = PackSource.create(name -> Component.translatable((String)"pack.nameAndSource", (Object[])new Object[]{name, Component.translatable((String)"pack.source.openloader")}).withStyle(ChatFormatting.GREEN), (boolean)true);
    private final RepoType type;
    private final List<File> directories;
    private final ConfigSchema.PackConfig config;

    public OpenLoaderRepositorySource(RepoType type, ConfigSchema.PackConfig config, Path configDir) {
        this.type = type;
        this.config = config;
        this.directories = new ArrayList<File>();
        this.directories.add(configDir.resolve(type.getPath()).toFile());
        for (String customDir : config.additionalFolders) {
            this.directories.add(new File(customDir));
        }
        for (File directory : this.directories) {
            if (!directory.exists()) {
                Constants.LOG.info("Generating new {} folder at {}.", (Object)type.displayName, (Object)directory.getAbsolutePath());
                directory.mkdirs();
            }
            if (directory.isDirectory()) continue;
            Constants.LOG.error("Improper {} folder specified. Must be a directory! See {}.", (Object)type.displayName, (Object)directory.getAbsolutePath());
            throw new IllegalStateException("Can not load " + type.displayName + " from non-directory. " + directory.getAbsolutePath());
        }
    }

    public void loadPacks(Consumer<Pack> consumer) {
        if (this.config.enabled) {
            Constants.LOG.info("Preparing {} injection.", (Object)this.type.displayName);
            for (File parentDirectory : this.directories) {
                int newPackCount = 0;
                for (File packCandidate : Objects.requireNonNull(parentDirectory.listFiles())) {
                    String typeName;
                    boolean isFolderPack;
                    boolean isArchivePack = this.isArchivePack(packCandidate);
                    boolean bl = isFolderPack = !isArchivePack && OpenLoaderRepositorySource.isFolderPack(packCandidate);
                    String string = isArchivePack ? "archive" : (typeName = isFolderPack ? "folder" : "invalid");
                    if (isArchivePack || isFolderPack) {
                        MutableComponent displayName;
                        String packName = this.type.getPath() + "/" + packCandidate.getName();
                        Pack pack = Pack.readMetaAndCreate((String)packName, (Component)(displayName = Component.literal((String)packName)), (boolean)true, (Pack.ResourcesSupplier)this.createPackSupplier(packCandidate), (PackType)this.type.getPackType(), (Pack.Position)Pack.Position.TOP, (PackSource)SOURCE);
                        if (pack == null) continue;
                        consumer.accept(pack);
                        ++newPackCount;
                        Constants.LOG.info("Loaded {} {} from {}.", (Object)typeName, (Object)this.type.getName(), (Object)packCandidate.getAbsolutePath());
                        continue;
                    }
                    Constants.LOG.debug("Skipping invalid {} {} from {}", (Object)typeName, (Object)this.type.getName(), (Object)packCandidate.getAbsolutePath());
                }
                Constants.LOG.info("Successfully injected {} packs from {}.", (Object)newPackCount, (Object)parentDirectory.getAbsolutePath());
            }
        } else {
            Constants.LOG.info("Skipping {}. Disabled by user config.", (Object)this.type.displayName);
        }
    }

    private Pack.ResourcesSupplier createPackSupplier(File packFile) {
        return packFile.isDirectory() ? new PathPackResources.PathResourcesSupplier(packFile.toPath(), false) : new FilePackResources.FileResourcesSupplier(packFile, false);
    }

    private boolean isArchivePack(File candidate) {
        return candidate.isFile() && (OpenLoaderRepositorySource.endsWithIgnoreCase(candidate.getName(), ".zip") || OpenLoaderRepositorySource.endsWithIgnoreCase(candidate.getName(), ".jar"));
    }

    private static boolean isFolderPack(File candidate) {
        if (candidate.isDirectory()) {
            if (new File(candidate, "pack.mcmeta").isFile()) {
                return true;
            }
            Constants.LOG.warn("Can not load {} as a folder pack. It is missing a pack.mcmeta file!", (Object)candidate.getAbsolutePath());
        }
        return false;
    }

    private static boolean endsWithIgnoreCase(String str, String suffix) {
        int suffixLength = suffix.length();
        return str.regionMatches(true, str.length() - suffixLength, suffix, 0, suffixLength);
    }
}

