/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader.commands;

import java.nio.file.Path;
import java.util.List;
import net.darkhax.openloader.commands.ClientCommand;
import net.darkhax.openloader.config.ConfigSchema;
import net.darkhax.openloader.packs.RepoType;
import net.minecraft.Util;

public record OpenLoaderClientCommand(Path configDir, ConfigSchema config) implements ClientCommand
{
    @Override
    public int execute() {
        return 0;
    }

    @Override
    public String id() {
        return "openloader";
    }

    @Override
    public List<ClientCommand> commands() {
        return List.of(new RepoCommand(this.configDir, this.config));
    }

    private record RepoCommand(Path configDir, ConfigSchema config) implements ClientCommand
    {
        @Override
        public int execute() {
            Util.getPlatform().openFile(this.configDir.toFile());
            return 1;
        }

        @Override
        public String id() {
            return "folder";
        }

        @Override
        public List<ClientCommand> commands() {
            return List.of(new SubRepoCommand(this.configDir, RepoType.DATA, this.config.dataPacks), new SubRepoCommand(this.configDir, RepoType.RESOURCES, this.config.resourcePacks));
        }
    }

    private record SubRepoCommand(Path configDir, RepoType type, ConfigSchema.PackConfig config) implements ClientCommand
    {
        @Override
        public int execute() {
            Util.getPlatform().openFile(this.configDir.resolve(this.type.getPath()).toFile());
            return 1;
        }

        @Override
        public String id() {
            return this.type.getPath();
        }

        @Override
        public boolean isHidden() {
            return !this.config.enabled;
        }
    }
}

