/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader;

import java.nio.file.Path;
import net.darkhax.openloader.Constants;
import net.darkhax.openloader.config.ConfigSchema;
import net.darkhax.openloader.packs.OpenLoaderRepositorySource;
import net.darkhax.openloader.packs.RepoType;
import net.minecraft.server.packs.repository.RepositorySource;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@Mod(value="openloader")
public class OpenLoaderNeoForge {
    public static ConfigSchema config;
    public static Path configDir;

    public OpenLoaderNeoForge() {
        configDir = FMLPaths.CONFIGDIR.get().resolve("openloader");
        config = ConfigSchema.load(configDir);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::injectPackRepositories);
    }

    private void injectPackRepositories(AddPackFindersEvent event) {
        switch (event.getPackType()) {
            case CLIENT_RESOURCES: {
                event.addRepositorySource((RepositorySource)new OpenLoaderRepositorySource(RepoType.RESOURCES, OpenLoaderNeoForge.config.resourcePacks, configDir));
                break;
            }
            case SERVER_DATA: {
                event.addRepositorySource((RepositorySource)new OpenLoaderRepositorySource(RepoType.DATA, OpenLoaderNeoForge.config.dataPacks, configDir));
                break;
            }
            default: {
                Constants.LOG.warn("Encountered unknown pack type {}. Nothing will be loaded for this type.", (Object)event.getPackType().name());
            }
        }
    }
}

