/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader.packs;

import com.google.gson.JsonElement;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.darkhax.openloader.Constants;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_8824;

public class PackOptions {
    @Expose
    @SerializedName(value="enabled")
    public boolean enabled = true;
    @Expose
    @SerializedName(value="required")
    public boolean required = true;
    @Expose
    @SerializedName(value="position")
    public String position = "top";
    @Expose
    @SerializedName(value="pack_name")
    public JsonElement packName = null;
    @Expose
    @SerializedName(value="description")
    public JsonElement description = null;
    @Expose
    @SerializedName(value="description_includes_source")
    public boolean addSourceToDescription = true;
    @Expose
    @SerializedName(value="fixed_position")
    public boolean fixedPosition = false;

    public String toString() {
        return "PackOptions[enabled=" + this.enabled + ",required=" + this.required + ",position=" + this.position + "]";
    }

    public class_3288.class_3289 getPosition() {
        if (this.position != null) {
            if (this.position.equalsIgnoreCase("top")) {
                return class_3288.class_3289.field_14280;
            }
            if (this.position.equalsIgnoreCase("bottom")) {
                return class_3288.class_3289.field_14281;
            }
            Constants.LOG.error("Position type '{}' is not valid. You must use 'top' or 'bottom'.", (Object)this.position);
        }
        return class_3288.class_3289.field_14280;
    }

    public class_2561 getDisplayName(String defaultPackName) {
        if (this.packName != null) {
            if (this.packName.isJsonPrimitive() && this.packName.getAsJsonPrimitive().isString()) {
                return class_2561.method_43470((String)this.packName.getAsString());
            }
            if (this.packName.isJsonObject() || this.packName.isJsonArray()) {
                try {
                    return (class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)JsonOps.INSTANCE, (Object)this.packName).getOrThrow(false, error -> Constants.LOG.error("Invalid pack name for pack '{}': {}", (Object)defaultPackName, error))).getFirst();
                }
                catch (RuntimeException e) {
                    Constants.LOG.error((Object)e);
                }
            }
        }
        return class_2561.method_43470((String)defaultPackName);
    }

    public class_2561 getDescription(String pack, class_2561 defaultDescription) {
        if (this.description != null) {
            if (this.description.isJsonPrimitive() && this.description.getAsJsonPrimitive().isString()) {
                return class_2561.method_43470((String)this.description.getAsString());
            }
            if (this.description.isJsonObject() || this.description.isJsonArray()) {
                try {
                    return (class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)JsonOps.INSTANCE, (Object)this.description).getOrThrow(false, error -> Constants.LOG.error("Invalid pack description for pack '{}': {}", (Object)pack, error))).getFirst();
                }
                catch (RuntimeException e) {
                    Constants.LOG.error((Object)e);
                }
            }
        }
        return defaultDescription;
    }

    public static PackOptions readOptions(File packCandidate) {
        File optionsFile = new File(packCandidate.getParent(), packCandidate.getName() + ".packmeta");
        if (!optionsFile.exists() && !(optionsFile = new File(packCandidate.getParent(), packCandidate.getName() + ".packmeta.json")).exists()) {
            optionsFile = new File(packCandidate.getParent(), packCandidate.getName() + ".json");
        }
        if (optionsFile.exists()) {
            if (optionsFile.isFile()) {
                PackOptions packOptions;
                FileReader reader = new FileReader(optionsFile);
                try {
                    packOptions = (PackOptions)Constants.GSON.fromJson((Reader)reader, PackOptions.class);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Constants.LOG.error("Failed to read pack options. The file is not formatted correctly! {}", (Object)optionsFile.getAbsolutePath());
                        Constants.LOG.catching((Throwable)e);
                    }
                }
                reader.close();
                return packOptions;
            } else {
                Constants.LOG.error("Pack options must be a file! {}", (Object)optionsFile.getAbsolutePath());
            }
        }
        Constants.LOG.debug("Using default pack options for {}", (Object)optionsFile.getAbsolutePath());
        return new PackOptions();
    }
}

