/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader.packs;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.darkhax.openloader.Constants;
import net.darkhax.openloader.config.ConfigSchema;
import net.darkhax.openloader.packs.PackOptions;
import net.darkhax.openloader.packs.RepoType;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;

public class OpenLoaderRepositorySource
implements class_3285 {
    private final RepoType type;
    private final List<File> directories;
    private final ConfigSchema modConfig;
    private final ConfigSchema.PackConfig config;

    public OpenLoaderRepositorySource(RepoType type, ConfigSchema.PackConfig repoConfig, Path configDir, ConfigSchema modConfig) {
        this.type = type;
        this.config = repoConfig;
        this.modConfig = modConfig;
        this.directories = new ArrayList<File>();
        this.directories.add(configDir.resolve(type.getPath()).toFile());
        for (String customDir : repoConfig.additionalFolders) {
            this.directories.add(new File(customDir));
        }
        for (File directory : this.directories) {
            if (!directory.exists()) {
                Constants.LOG.info("Generating new {} folder at {}.", (Object)type.displayName, (Object)directory.getAbsolutePath());
                directory.mkdirs();
            }
            if (directory.isDirectory()) continue;
            Constants.LOG.error("Improper {} folder specified. Must be a directory! See {}.", (Object)type.displayName, (Object)directory.getAbsolutePath());
            throw new IllegalStateException("Can not load " + type.displayName + " from non-directory. " + directory.getAbsolutePath());
        }
    }

    public void method_14453(Consumer<class_3288> consumer) {
        File resourcePackDir;
        if (this.config.enabled) {
            Constants.LOG.info("Preparing {} injection.", (Object)this.type.displayName);
            for (File parentDirectory : this.directories) {
                int newPackCount = 0;
                File[] fileArray = Objects.requireNonNull(parentDirectory.listFiles());
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File packCandidate = fileArray[i];
                    if (!this.loadPack(packCandidate, consumer)) continue;
                    ++newPackCount;
                }
                Constants.LOG.info("Successfully injected {} packs from {}.", (Object)newPackCount, (Object)parentDirectory.getAbsolutePath());
            }
        } else {
            Constants.LOG.info("Skipping {}. Disabled by user config.", (Object)this.type.displayName);
        }
        if (this.type == RepoType.DATA && this.modConfig.loadResourcePackData && (resourcePackDir = new File("resourcepacks")).exists() && resourcePackDir.isDirectory()) {
            int newPackCount = 0;
            for (File packCandidate : Objects.requireNonNull(resourcePackDir.listFiles())) {
                if (!OpenLoaderRepositorySource.isPotentialDatapack(packCandidate.toPath()) || !this.loadPack(packCandidate, consumer)) continue;
                ++newPackCount;
            }
            Constants.LOG.info("Successfully injected {} packs from {}.", (Object)newPackCount, (Object)resourcePackDir.getAbsolutePath());
        }
    }

    private boolean loadPack(File packCandidate, Consumer<class_3288> consumer) {
        PackFileType fileType = PackFileType.getType(packCandidate);
        if (fileType.isLoadable()) {
            String packName = this.type.getPath() + "/" + packCandidate.getName();
            PackOptions options = PackOptions.readOptions(packCandidate);
            if (options.enabled) {
                if (options.fixedPosition && !options.required) {
                    Constants.LOG.error("Pack '{}' has a fixed position but is not required. This is not allowed! The pack can not be loaded.", (Object)packName);
                    return false;
                }
                class_5352 source = class_5352.method_45281(rawDesc -> {
                    class_2561 description = options.getDescription(packName, (class_2561)rawDesc);
                    if (options.addSourceToDescription && this.modConfig.appendSourceToPacks) {
                        description = class_2561.method_43469((String)"pack.nameAndSource", (Object[])new Object[]{description, class_2561.method_43471((String)"pack.source.openloader").method_27692(class_124.field_1062)});
                    }
                    return description;
                }, (boolean)true);
                class_3288 pack = OpenLoaderRepositorySource.readMetaAndCreate(packName, options.getDisplayName(packName), options.required, fileType.createPackSupplier(packCandidate), this.type.getPackType(), options.getPosition(), source, options.fixedPosition);
                if (pack != null) {
                    consumer.accept(pack);
                    Constants.LOG.info("Loaded {} {} from {}.", (Object)fileType.typeName(), (Object)this.type.getName(), (Object)packCandidate.getAbsolutePath());
                    return true;
                }
            } else {
                Constants.LOG.debug("Pack '{}' has been disabled by config file.", (Object)packName);
            }
        } else {
            Constants.LOG.debug("Skipping invalid {} {} from {}", (Object)fileType.typeName(), (Object)this.type.getName(), (Object)packCandidate.getAbsolutePath());
        }
        return false;
    }

    private static boolean isPotentialDatapack(Path filePath) {
        if (Files.isRegularFile(filePath, new LinkOption[0])) {
            boolean bl;
            block11: {
                FileSystem fs = FileSystems.newFileSystem(filePath);
                try {
                    boolean bl2 = bl = Files.isDirectory(fs.getPath("data/", new String[0]), new LinkOption[0]) && Files.isRegularFile(fs.getPath("pack.mcmeta", new String[0]), new LinkOption[0]);
                    if (fs == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (fs != null) {
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                }
                fs.close();
            }
            return bl;
        } else if (Files.isDirectory(filePath, new LinkOption[0])) {
            return Files.isDirectory(filePath.resolve("data"), new LinkOption[0]) && Files.isRegularFile(filePath.resolve("pack.mcmeta"), new LinkOption[0]);
        }
        return false;
    }

    private static boolean endsWithIgnoreCase(String str, String suffix) {
        int suffixLength = suffix.length();
        return str.regionMatches(true, str.length() - suffixLength, suffix, 0, suffixLength);
    }

    @Nullable
    public static class_3288 readMetaAndCreate(String id, class_2561 title, boolean required, class_3288.class_7680 resourceSupplier, class_3264 type, class_3288.class_3289 position, class_5352 source, boolean fixedPosition) {
        int manifestVersion = class_155.method_16673().method_48017(type);
        class_3288.class_7679 packInfo = class_3288.method_45274((String)id, (class_3288.class_7680)resourceSupplier, (int)manifestVersion);
        return packInfo != null ? class_3288.method_14456((String)id, (class_2561)title, (boolean)required, (class_3288.class_7680)resourceSupplier, (class_3288.class_7679)packInfo, (class_3288.class_3289)position, (boolean)fixedPosition, (class_5352)source) : null;
    }

    public static enum PackFileType {
        ARCHIVE(true, file -> new class_3258.class_8615(file, false)),
        FOLDER(true, file -> new class_3259.class_8619(file.toPath(), false)),
        INVALID(false, file -> null);

        private final boolean loadable;
        private final Function<File, class_3288.class_7680> packSupplier;

        private PackFileType(boolean loadable, Function<File, class_3288.class_7680> packSupplier) {
            this.loadable = loadable;
            this.packSupplier = packSupplier;
        }

        public boolean isLoadable() {
            return this.loadable;
        }

        public String typeName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        private class_3288.class_7680 createPackSupplier(File packFile) {
            return this.packSupplier.apply(packFile);
        }

        public static PackFileType getType(File candidate) {
            if (candidate.isFile() && (OpenLoaderRepositorySource.endsWithIgnoreCase(candidate.getName(), ".zip") || OpenLoaderRepositorySource.endsWithIgnoreCase(candidate.getName(), ".jar"))) {
                return ARCHIVE;
            }
            if (candidate.isDirectory()) {
                if (new File(candidate, "pack.mcmeta").isFile()) {
                    return FOLDER;
                }
                Constants.LOG.warn("Can not load {} as a folder pack. It is missing a pack.mcmeta file!", (Object)candidate.getAbsolutePath());
            }
            return INVALID;
        }
    }
}

