/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader.config;

import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.darkhax.openloader.Constants;
import net.darkhax.openloader.packs.RepoType;

public class ConfigSchema {
    @Expose
    public PackConfig resourcePacks = new PackConfig();
    @Expose
    public PackConfig dataPacks = new PackConfig();
    @Expose
    public boolean appendSourceToPacks = true;
    @Expose
    public boolean loadResourcePackData = true;

    public static ConfigSchema load(Path configDir) {
        RepoType.DATA.createDirectory(configDir);
        RepoType.RESOURCES.createDirectory(configDir);
        File configFile = configDir.resolve("advanced_options.json").toFile();
        ConfigSchema defaultConfig = new ConfigSchema();
        if (configFile.exists()) {
            ConfigSchema configSchema;
            FileReader reader = new FileReader(configFile);
            try {
                configSchema = (ConfigSchema)Constants.GSON.fromJson((Reader)reader, ConfigSchema.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Constants.LOG.error("Could not read config file {}. Defaults will be used.", (Object)configFile.getAbsolutePath());
                    Constants.LOG.catching((Throwable)e);
                }
            }
            reader.close();
            return configSchema;
        } else {
            Constants.LOG.info("Creating a new config file at {}.", (Object)configFile.getAbsolutePath());
            configFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(configFile);){
            Constants.GSON.toJson((Object)defaultConfig, (Appendable)writer);
            Constants.LOG.info("Default configuration file generated at {}.", (Object)configFile.getAbsolutePath());
        }
        catch (IOException e) {
            Constants.LOG.error("Could not write config file '{}'!", (Object)configFile.getAbsolutePath());
            Constants.LOG.catching((Throwable)e);
        }
        return defaultConfig;
    }

    public static class PackConfig {
        @Expose
        public boolean enabled = true;
        @Expose
        public String[] additionalFolders = new String[0];
    }
}

