package net.darkhax.openloader.packs;

import com.google.gson.JsonElement;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.mojang.serialization.JsonOps;
import net.darkhax.openloader.Constants;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_8824;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class PackOptions {

    @Expose
    @SerializedName("enabled")
    public boolean enabled = true;

    @Expose
    @SerializedName("required")
    public boolean required = true;

    @Expose
    @SerializedName("position")
    public String position = "top";

    @Expose
    @SerializedName("pack_name")
    public JsonElement packName = null;

    @Expose
    @SerializedName("description")
    public JsonElement description = null;

    @Expose
    @SerializedName("description_includes_source")
    public boolean addSourceToDescription = true;

    @Expose
    @SerializedName("fixed_position")
    public boolean fixedPosition = false;

    @Override
    public String toString() {

        return "PackOptions[enabled=" + enabled + ",required=" + required + ",position=" + position + "]";
    }

    public class_3288.class_3289 getPosition() {

        if (position != null) {

            if (position.equalsIgnoreCase("top")) {
                return class_3288.class_3289.field_14280;
            }

            else if (position.equalsIgnoreCase("bottom")) {
                return class_3288.class_3289.field_14281;
            }

            else {
                Constants.LOG.error("Position type '{}' is not valid. You must use 'top' or 'bottom'.", this.position);
            }
        }

        return class_3288.class_3289.field_14280;
    }

    public class_2561 getDisplayName(String defaultPackName) {

        if (packName != null) {

            if (packName.isJsonPrimitive() && packName.getAsJsonPrimitive().isString()) {

                return class_2561.method_43470(packName.getAsString());
            }

            else if (packName.isJsonObject() || packName.isJsonArray()) {

                try {

                    return class_8824.field_46597.decode(JsonOps.INSTANCE, this.packName).getOrThrow(false, error -> Constants.LOG.error("Invalid pack name for pack '{}': {}", defaultPackName, error)).getFirst();
                }

                catch (RuntimeException e) {

                    Constants.LOG.error(e);
                }
            }
        }

        return class_2561.method_43470(defaultPackName);
    }

    public class_2561 getDescription(String pack, class_2561 defaultDescription) {

        if (description != null) {

            if (description.isJsonPrimitive() && description.getAsJsonPrimitive().isString()) {

                return class_2561.method_43470(description.getAsString());
            }

            else if (description.isJsonObject() || description.isJsonArray()) {

                try {

                    return class_8824.field_46597.decode(JsonOps.INSTANCE, this.description).getOrThrow(false, error -> Constants.LOG.error("Invalid pack description for pack '{}': {}", pack, error)).getFirst();
                }

                catch (RuntimeException e) {

                    Constants.LOG.error(e);
                }
            }
        }

        return defaultDescription;
    }

    public static PackOptions readOptions(File packCandidate) {

        File optionsFile = new File(packCandidate.getParent(), packCandidate.getName() + ".packmeta");

        if (!optionsFile.exists()) {

            optionsFile = new File(packCandidate.getParent(), packCandidate.getName() + ".packmeta.json");

            if (!optionsFile.exists()) {

                optionsFile = new File(packCandidate.getParent(), packCandidate.getName() + ".json");
            }
        }

        if (optionsFile.exists()) {

            if (optionsFile.isFile()) {

                try (FileReader reader = new FileReader(optionsFile)) {

                    return Constants.GSON.fromJson(reader, PackOptions.class);
                }

                catch (IOException e) {

                    Constants.LOG.error("Failed to read pack options. The file is not formatted correctly! {}", optionsFile.getAbsolutePath());
                    Constants.LOG.catching(e);
                }
            }

            else {

                Constants.LOG.error("Pack options must be a file! {}", optionsFile.getAbsolutePath());
            }
        }

        // defaults
        Constants.LOG.debug("Using default pack options for {}", optionsFile.getAbsolutePath());
        return new PackOptions();
    }
}
