package net.darkhax.openloader.mixin;

import net.darkhax.openloader.OpenLoaderFabric;
import net.darkhax.openloader.packs.OpenLoaderRepositorySource;
import net.darkhax.openloader.packs.RepoType;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Consumer;

@Mixin(ModResourcePackCreator.class)
public class MixinModResourcePackCreator {

    @Final
    @Shadow
    private class_3264 type;

    @Unique
    private OpenLoaderRepositorySource newSource;

    @Inject(method = "<init>(Lnet/minecraft/server/packs/PackType;)V", at = @At("RETURN"))
    private void onConstruction(class_3264 type, CallbackInfo callback) {

        if (type == class_3264.field_14190) {

            this.newSource = new OpenLoaderRepositorySource(RepoType.DATA, OpenLoaderFabric.config.dataPacks, OpenLoaderFabric.configDir, OpenLoaderFabric.config);
        }

        else if (type == class_3264.field_14188) {

            this.newSource = new OpenLoaderRepositorySource(RepoType.RESOURCES, OpenLoaderFabric.config.resourcePacks, OpenLoaderFabric.configDir, OpenLoaderFabric.config);
        }
    }

    @Inject(method = "loadPacks(Ljava/util/function/Consumer;)V", at = @At("RETURN"))
    private void loadPacks(Consumer<class_3288> consumer, CallbackInfo callback) {

        if (this.newSource != null) {

            this.newSource.method_14453(consumer);
        }
    }
}