/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy.enchantments;

import java.util.function.Supplier;
import net.darkhax.bookshelf.api.registry.RegistryObject;
import net.darkhax.msmlegacy.MSMContent;
import net.darkhax.msmlegacy.enchantments.SwordEnchantment;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.dimension.DimensionType;

public class EnchantmentScorn
extends SwordEnchantment {
    private static TagKey<DimensionType> ignored_dimensions = TagKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)new ResourceLocation("msmlegacy", "scorn_inactive_types"));
    private static Supplier<Enchantment> scorn = RegistryObject.deferred((Registry)BuiltInRegistries.ENCHANTMENT, (ResourceLocation)new ResourceLocation("msmlegacy", "scorn")).cast();

    public EnchantmentScorn(String type) {
        super(Enchantment.Rarity.UNCOMMON, type, MSMContent.CONFIG.enchantments.scorn);
    }

    public static float modifyBaseDamage(Player player, float baseDamage) {
        int scornLevel = EnchantmentHelper.getEnchantmentLevel((Enchantment)scorn.get(), (LivingEntity)player);
        if (scornLevel > 0 && !player.level().dimensionTypeRegistration().is(ignored_dimensions)) {
            return baseDamage * MSMContent.CONFIG.enchantments.scorn.damageModifier.getValue(scornLevel);
        }
        return baseDamage;
    }
}

