/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy.enchantments;

import net.darkhax.msmlegacy.MSMContent;
import net.darkhax.msmlegacy.config.enchantment.FrostWaveConfig;
import net.darkhax.msmlegacy.enchantments.SwordEnchantment;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class EnchantmentFrostWave
extends SwordEnchantment {
    public EnchantmentFrostWave(String type) {
        super(Enchantment.Rarity.UNCOMMON, type, MSMContent.CONFIG.enchantments.frostWave);
    }

    public void doPostAttack(LivingEntity attacker, Entity target, int level) {
        FrostWaveConfig config = MSMContent.CONFIG.enchantments.frostWave;
        Level level2 = attacker.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            if (target instanceof LivingEntity) {
                for (LivingEntity nearby : serverLevel.getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate((double)config.range.getValue(level), 0.25, (double)config.range.getValue(level)))) {
                    OwnableEntity ownable;
                    TamableAnimal tamable;
                    if (nearby == attacker || nearby == target || attacker.isAlliedTo((Entity)nearby) || nearby instanceof ArmorStand || !(attacker.distanceToSqr((Entity)nearby) < 9.0) || nearby instanceof TamableAnimal && (tamable = (TamableAnimal)nearby).isOwnedBy(attacker) || nearby instanceof OwnableEntity && (ownable = (OwnableEntity)nearby).getOwner() == attacker) continue;
                    config.effect.applyEffect((Entity)nearby, level);
                    if (!(attacker.getRandom().nextFloat() < config.damageChance.getValue(level))) continue;
                    nearby.hurt(attacker.level().damageSources().freeze(), config.frostDamage.getValue(level));
                }
            }
        }
    }
}

