/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy.enchantments;

import net.darkhax.bookshelf.api.util.PlayerHelper;
import net.darkhax.msmlegacy.MSMContent;
import net.darkhax.msmlegacy.config.enchantment.EnderPulseConfig;
import net.darkhax.msmlegacy.enchantments.SwordEnchantment;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EnchantmentEnderPulse
extends SwordEnchantment {
    public EnchantmentEnderPulse(String type) {
        super(Enchantment.Rarity.COMMON, type, MSMContent.CONFIG.enchantments.enderPulse);
    }

    @Override
    public InteractionResultHolder<ItemStack> onItemUsed(Level worldLevel, Player player, InteractionHand hand, int level) {
        ItemStack heldStack = player.getItemInHand(hand);
        int cooldown = PlayerHelper.getRemainingCooldownTicks((Player)player, (Item)heldStack.getItem());
        if (cooldown <= 0) {
            EnderPulseConfig config = MSMContent.CONFIG.enchantments.enderPulse;
            HitResult hitResult = player.pick((double)config.distance.getValue(level), 0.0f, false);
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockInfo = (BlockHitResult)hitResult;
                BlockPos warpPos = blockInfo.getBlockPos().relative(blockInfo.getDirection());
                if (worldLevel.getBlockState(warpPos).isAir() && worldLevel.getBlockState(warpPos.above()).isAir()) {
                    player.teleportTo((double)((float)warpPos.getX() + 0.5f), (double)((float)warpPos.getY() + 0.01f), (double)((float)warpPos.getZ() + 0.5f));
                    player.getCooldowns().addCooldown(heldStack.getItem(), config.cooldownTime.getValue(level));
                    return InteractionResultHolder.success((Object)heldStack);
                }
                player.sendSystemMessage((Component)Component.translatable((String)"msmlegacy.messages.enchantment.no_space"));
            }
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"msmlegacy.messages.enchantment.cooldown", (Object[])new Object[]{this.getName(), Math.ceil((double)cooldown / 20.0)}));
        }
        return null;
    }
}

