/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy.enchantments;

import net.darkhax.msmlegacy.MSMContent;
import net.darkhax.msmlegacy.config.enchantment.EnderAuraConfig;
import net.darkhax.msmlegacy.enchantments.SwordEnchantment;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class EnchantmentEnderAura
extends SwordEnchantment {
    public EnchantmentEnderAura(String type) {
        super(Enchantment.Rarity.UNCOMMON, type, MSMContent.CONFIG.enchantments.enderaura);
    }

    public void doPostHurt(LivingEntity user, Entity attacker, int level) {
        super.doPostHurt(user, attacker, level);
        EnderAuraConfig config = MSMContent.CONFIG.enchantments.enderaura;
        Level level2 = user.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            if (user.getRandom().nextFloat() < config.chance.getValue(level)) {
                double posX = user.getX();
                double posY = user.getY();
                double posZ = user.getZ();
                for (int attempts = 0; attempts < 16; ++attempts) {
                    double randomX = posX + (user.getRandom().nextDouble() - 0.5) * (double)config.warpRange.getValue(level);
                    double randomY = Mth.clamp((double)(posY + (double)(user.getRandom().nextInt(config.warpRange.getValue(level)) - 8)), (double)serverLevel.getMinBuildHeight(), (double)(serverLevel.getMinBuildHeight() + serverLevel.getLogicalHeight() - 1));
                    double randomZ = posZ + (user.getRandom().nextDouble() - 0.5) * (double)config.warpRange.getValue(level);
                    if (user.isPassenger()) {
                        user.stopRiding();
                    }
                    Vec3 oldPosition = user.position();
                    if (!user.randomTeleport(randomX, randomY, randomZ, true)) continue;
                    serverLevel.gameEvent(GameEvent.TELEPORT, oldPosition, GameEvent.Context.of((Entity)user));
                    serverLevel.playSound(null, posX, posY, posZ, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    user.playSound(SoundEvents.CHORUS_FRUIT_TELEPORT, 1.0f, 1.0f);
                    break;
                }
            }
        }
    }
}

