/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy.config.types;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public class LevelScaledInt {
    public static final TypeAdapter<LevelScaledInt> ADAPTER = new Adapter();
    private int[] values;

    public int getValue(int level) {
        if (this.values.length == 1) {
            return this.values[0] * level;
        }
        int valueIndex = level - 1;
        if (valueIndex < 0) {
            return this.values[0];
        }
        if (valueIndex > this.values.length - 1) {
            return this.values[this.values.length - 1];
        }
        return this.values[valueIndex];
    }

    public LevelScaledInt(int f) {
        this(new int[]{f});
    }

    public LevelScaledInt(int ... values) {
        this.values = values;
    }

    public static class Adapter
    extends TypeAdapter<LevelScaledInt> {
        public void write(JsonWriter out, LevelScaledInt value) throws IOException {
            if (value.values.length == 1) {
                out.value((long)value.values[0]);
            } else {
                out.beginArray();
                for (int fval : value.values) {
                    out.value((long)fval);
                }
                out.endArray();
            }
        }

        public LevelScaledInt read(JsonReader in) throws IOException {
            if (in.hasNext()) {
                JsonToken type = in.peek();
                if (type == JsonToken.BEGIN_ARRAY) {
                    ArrayList<Integer> values = new ArrayList<Integer>();
                    in.beginArray();
                    while (in.hasNext()) {
                        values.add(in.nextInt());
                    }
                    in.endArray();
                    return new LevelScaledInt(ArrayUtils.toPrimitive((Integer[])values.toArray(new Integer[0])));
                }
                return new LevelScaledInt(in.nextInt());
            }
            throw new JsonParseException("Value expected to be a double or double array.");
        }
    }
}

