/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy.addons.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.darkhax.msmlegacy.MSMContent;
import net.darkhax.msmlegacy.item.MSMSwordItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@JeiPlugin
public class MSMJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("msmlegacy", "jei_plugin");
    }

    public void registerRecipes(IRecipeRegistration registry) {
        IVanillaRecipeFactory vanillaFactory = registry.getVanillaRecipeFactory();
        if (MSMContent.INSTANCE != null) {
            ArrayList<IJeiAnvilRecipe> repairData = new ArrayList<IJeiAnvilRecipe>();
            for (Item item : MSMContent.INSTANCE.items) {
                if (!(item instanceof MSMSwordItem)) continue;
                MSMSwordItem sword = (MSMSwordItem)item;
                ItemStack quarterDamage = item.getDefaultInstance();
                quarterDamage.setDamageValue((int)((float)quarterDamage.getMaxDamage() * 0.75f));
                ItemStack halfDamaged = item.getDefaultInstance();
                halfDamaged.setDamageValue((int)((float)halfDamaged.getMaxDamage() * 0.5f));
                ItemStack fullyDamaged = item.getDefaultInstance();
                fullyDamaged.setDamageValue(fullyDamaged.getMaxDamage());
                repairData.add(vanillaFactory.createAnvilRecipe(List.of(quarterDamage.copy()), List.of(quarterDamage.copy()), List.of(halfDamaged.copy())));
                repairData.add(vanillaFactory.createAnvilRecipe(List.of(fullyDamaged), List.of(sword.getRepairMaterials().getItems()), List.of(quarterDamage)));
            }
            if (!repairData.isEmpty()) {
                registry.addRecipes(RecipeTypes.ANVIL, repairData);
            }
        }
    }
}

