/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy;

import java.util.List;
import java.util.UUID;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.registry.RegistryObject;
import net.darkhax.msmlegacy.MSMContent;
import net.darkhax.msmlegacy.config.relics.RelicAqueousBladeConfig;
import net.darkhax.msmlegacy.config.relics.RelicBlazeSwordConfig;
import net.darkhax.msmlegacy.config.relics.RelicInfinityBladeConfig;
import net.darkhax.msmlegacy.config.relics.RelicKeyBladeConfig;
import net.darkhax.msmlegacy.config.relics.RelicMasterSword;
import net.darkhax.msmlegacy.config.relics.RelicMoltenBlade;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class RelicHooks {
    public static final CachedSupplier<Item> AQUEOUS_BLADE = RegistryObject.deferred((Registry)BuiltInRegistries.ITEM, (String)"msmlegacy", (String)"relic_aqueous_blade").cast();
    public static final CachedSupplier<Item> BLAZE_SWORD = RegistryObject.deferred((Registry)BuiltInRegistries.ITEM, (String)"msmlegacy", (String)"relic_blaze_sword").cast();
    public static final CachedSupplier<Item> INFINITY_BLADE = RegistryObject.deferred((Registry)BuiltInRegistries.ITEM, (String)"msmlegacy", (String)"relic_infinity_blade").cast();
    public static final TagKey<Biome> CAN_HEROES_SHADE_SPAWN = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation("msmlegacy", "can_heroes_shade_spawn"));
    public static final CachedSupplier<Item> MASTER_SWORD = RegistryObject.deferred((Registry)BuiltInRegistries.ITEM, (String)"msmlegacy", (String)"relic_master_sword").cast();
    public static final CachedSupplier<Item> KEY_BLADE = RegistryObject.deferred((Registry)BuiltInRegistries.ITEM, (String)"msmlegacy", (String)"relic_key_blade").cast();
    public static final CachedSupplier<Item> MOLTEN_BLADE = RegistryObject.deferred((Registry)BuiltInRegistries.ITEM, (String)"msmlegacy", (String)"relic_molten_blade").cast();
    public static final CachedSupplier<Item> PIE_CUTTER = RegistryObject.deferred((Registry)BuiltInRegistries.ITEM, (String)"msmlegacy", (String)"relic_pie_cutter").cast();
    public static final CachedSupplier<Item> ADMINIUM_ARK = RegistryObject.deferred((Registry)BuiltInRegistries.ITEM, (String)"msmlegacy", (String)"relic_adminium_ark").cast();

    public static void setupDrowned(Drowned drowned, RandomSource rng, DifficultyInstance difficulty) {
        RelicAqueousBladeConfig config = MSMContent.CONFIG.relics.aqueousBlade;
        if (config.isEnabled() && !drowned.isBaby() && drowned.getMainHandItem().isEmpty() && rng.nextFloat() < config.getChance()) {
            drowned.setItemSlot(EquipmentSlot.MAINHAND, ((Item)AQUEOUS_BLADE.get()).getDefaultInstance());
            drowned.setDropChance(EquipmentSlot.MAINHAND, config.dropChance);
            drowned.getAttribute(Attributes.ARMOR).addPermanentModifier(RelicHooks.modifier("bf1c00c1-7e71-4469-bdf8-6f36e0e87eda", "Aqueous Blade Armor Bonus", config.bonusArmor, AttributeModifier.Operation.ADDITION));
            drowned.getAttribute(Attributes.ATTACK_DAMAGE).addPermanentModifier(RelicHooks.modifier("10f7a49c-8446-4060-a9d2-eaae3d4d6c44", "Aqueous Blade Damage Bonus", config.bonusDamage, AttributeModifier.Operation.ADDITION));
            drowned.getAttribute(Attributes.MAX_HEALTH).addPermanentModifier(RelicHooks.modifier("ca380065-55df-44f6-a78d-eac4bdd44126", "Aqueous Blade Health Bonus", config.bonusHealth, AttributeModifier.Operation.ADDITION));
            drowned.heal((float)config.bonusHealth);
        }
    }

    public static void injectPiglinBarteringTrades(Piglin piglin, List<ItemStack> trades) {
        Player player;
        RelicBlazeSwordConfig config = MSMContent.CONFIG.relics.blazeSword;
        if (config.isEnabled() && !piglin.isRemoved() && (player = (Player)piglin.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER).orElse(null)) instanceof ServerPlayer) {
            float chance;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            float f = chance = !RelicHooks.doesPlayerHaveAdvancement(serverPlayer, "relics/relic_blaze_sword") ? config.newPlayerChance : config.baseChance;
            if (piglin.getRandom().nextFloat() < chance) {
                trades.add(((Item)BLAZE_SWORD.get()).getDefaultInstance());
            }
        }
    }

    public static void setupZombie(Zombie zombie, RandomSource rng, DifficultyInstance difficulty) {
        RelicInfinityBladeConfig config = MSMContent.CONFIG.relics.infinityBladeConfig;
        if (config.isEnabled() && !zombie.isBaby() && zombie.getType() == EntityType.ZOMBIE && zombie.getMainHandItem().isEmpty() && rng.nextFloat() < config.getChance() && !zombie.level().canSeeSky(zombie.blockPosition())) {
            zombie.setItemSlot(EquipmentSlot.MAINHAND, ((Item)INFINITY_BLADE.get()).getDefaultInstance());
            zombie.setDropChance(EquipmentSlot.MAINHAND, config.dropChance);
            if (config.useCustomArmor) {
                zombie.setItemSlot(EquipmentSlot.HEAD, Items.IRON_HELMET.getDefaultInstance());
                zombie.setDropChance(EquipmentSlot.HEAD, config.armorDropChance);
                zombie.setItemSlot(EquipmentSlot.CHEST, Items.IRON_CHESTPLATE.getDefaultInstance());
                zombie.setDropChance(EquipmentSlot.CHEST, config.armorDropChance);
                zombie.setItemSlot(EquipmentSlot.LEGS, Items.IRON_LEGGINGS.getDefaultInstance());
                zombie.setDropChance(EquipmentSlot.LEGS, config.armorDropChance);
                zombie.setItemSlot(EquipmentSlot.FEET, Items.IRON_BOOTS.getDefaultInstance());
                zombie.setDropChance(EquipmentSlot.FEET, config.armorDropChance);
            }
            zombie.getAttribute(Attributes.ARMOR).addPermanentModifier(RelicHooks.modifier("61ee61ca-f64b-4e65-9da8-2e57423a6253", "Infinity Blade Armor Bonus", config.bonusArmor, AttributeModifier.Operation.ADDITION));
            zombie.getAttribute(Attributes.ARMOR_TOUGHNESS).addPermanentModifier(RelicHooks.modifier("61ee61ca-f64b-4e65-9da8-2e57423a6253", "Infinity Blade Armor Toughness Bonus", config.bonusArmorToughness, AttributeModifier.Operation.ADDITION));
            zombie.getAttribute(Attributes.ATTACK_DAMAGE).addPermanentModifier(RelicHooks.modifier("694644a4-75be-4bfa-ad42-fc5f7176ca2a", "Infinity Blade Damage Bonus", config.bonusDamage, AttributeModifier.Operation.ADDITION));
            zombie.getAttribute(Attributes.MAX_HEALTH).addPermanentModifier(RelicHooks.modifier("42ff2949-af37-4edf-8164-5382360707e7", "Infinity Blade Health Bonus", config.bonusHealth, AttributeModifier.Operation.ADDITION));
            zombie.heal((float)config.bonusHealth);
        }
    }

    public static void setupSkeleton(AbstractSkeleton skeleton, RandomSource rng, DifficultyInstance difficulty) {
        RelicMasterSword config = MSMContent.CONFIG.relics.masterSwordConfig;
        if (config.isEnabled() && !skeleton.isBaby() && skeleton.getType() == EntityType.SKELETON && rng.nextFloat() < config.getChance() && RelicHooks.isBiome(skeleton.level(), skeleton.getOnPos(), CAN_HEROES_SHADE_SPAWN)) {
            AbstractSkeleton targetSkeleton = skeleton;
            if (config.replaceSkeleton) {
                targetSkeleton = (AbstractSkeleton)skeleton.convertTo(EntityType.WITHER_SKELETON, false);
            }
            targetSkeleton.setItemSlot(EquipmentSlot.MAINHAND, ((Item)MASTER_SWORD.get()).getDefaultInstance());
            targetSkeleton.setDropChance(EquipmentSlot.MAINHAND, config.dropChance);
            if (config.useCustomShield) {
                ItemStack shieldStack = Items.SHIELD.getDefaultInstance();
                CompoundTag shieldData = new CompoundTag();
                shieldData.putInt("Base", DyeColor.RED.getId());
                shieldData.put("Patterns", (Tag)new BannerPattern.Builder().addPattern(BannerPatterns.FLOWER, DyeColor.YELLOW).toListTag());
                BlockItem.setBlockEntityData((ItemStack)shieldStack, (BlockEntityType)BlockEntityType.BANNER, (CompoundTag)shieldData);
                targetSkeleton.setItemSlot(EquipmentSlot.OFFHAND, shieldStack);
                targetSkeleton.setDropChance(EquipmentSlot.OFFHAND, config.shieldDropChance);
            }
        }
    }

    public static void onPlayerWinsRaid(ServerPlayer player) {
        RelicKeyBladeConfig config = MSMContent.CONFIG.relics.keyBladeConfig;
        if (config.isEnabled()) {
            float dropChance;
            float f = dropChance = RelicHooks.doesPlayerHaveAdvancement(player, "relics/relic_key_blade") ? config.baseChance : config.newPlayerChance;
            if (player.level().random.nextFloat() < dropChance) {
                player.drop(((Item)KEY_BLADE.get()).getDefaultInstance(), true);
            }
        }
    }

    public static void setupWitherSkeleton(WitherSkeleton skeleton, RandomSource rng, DifficultyInstance difficulty) {
        RelicMoltenBlade config = MSMContent.CONFIG.relics.moltenBladeConfig;
        if (!skeleton.isBaby() && config.isEnabled() && rng.nextFloat() < config.getChance()) {
            skeleton.setItemSlot(EquipmentSlot.MAINHAND, ((Item)MOLTEN_BLADE.get()).getDefaultInstance());
            skeleton.setDropChance(EquipmentSlot.MAINHAND, config.dropChance);
        }
    }

    public static ItemStack dye(Item item, DyeColor color) {
        ItemStack stack = item.getDefaultInstance();
        stack.getOrCreateTagElement("display").putInt("color", color.getTextColor());
        return stack;
    }

    public static boolean isBiome(Level level, BlockPos pos, TagKey<Biome> biome) {
        return level.getBiome(pos).is(biome);
    }

    public static boolean doesPlayerHaveAdvancement(ServerPlayer player, String id) {
        return RelicHooks.doesPlayerHaveAdvancement(player, new ResourceLocation("msmlegacy", id));
    }

    public static boolean doesPlayerHaveAdvancement(ServerPlayer player, ResourceLocation id) {
        Advancement advancement = player.server.getAdvancements().getAdvancement(id);
        return advancement != null && player.getAdvancements().getOrStartProgress(advancement).isDone();
    }

    private static AttributeModifier modifier(String uuid, String name, double amount, AttributeModifier.Operation operation) {
        return new AttributeModifier(UUID.fromString(uuid), name, amount, operation);
    }
}

