/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy;

import java.util.function.Function;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.darkhax.msmlegacy.config.Config;
import net.darkhax.msmlegacy.config.SwordStatsConfig;
import net.darkhax.msmlegacy.enchantments.EnchantmentAbsorb;
import net.darkhax.msmlegacy.enchantments.EnchantmentAscension;
import net.darkhax.msmlegacy.enchantments.EnchantmentConsumingShadows;
import net.darkhax.msmlegacy.enchantments.EnchantmentDecay;
import net.darkhax.msmlegacy.enchantments.EnchantmentEnderAura;
import net.darkhax.msmlegacy.enchantments.EnchantmentEnderPulse;
import net.darkhax.msmlegacy.enchantments.EnchantmentFeast;
import net.darkhax.msmlegacy.enchantments.EnchantmentFrostWave;
import net.darkhax.msmlegacy.enchantments.EnchantmentFrozenAspect;
import net.darkhax.msmlegacy.enchantments.EnchantmentGreed;
import net.darkhax.msmlegacy.enchantments.EnchantmentIgnite;
import net.darkhax.msmlegacy.enchantments.EnchantmentKeenEdge;
import net.darkhax.msmlegacy.enchantments.EnchantmentScorn;
import net.darkhax.msmlegacy.enchantments.EnchantmentSkysGrace;
import net.darkhax.msmlegacy.enchantments.EnchantmentSparks;
import net.darkhax.msmlegacy.enchantments.EnchantmentVenomousAspect;
import net.darkhax.msmlegacy.enchantments.EnchantmentVitality;
import net.darkhax.msmlegacy.enchantments.EnchantmentWisdom;
import net.darkhax.msmlegacy.item.MSMSwordItem;
import net.darkhax.msmlegacy.item.RelicSwordItem;
import net.darkhax.msmlegacy.trades.MerchantOfferPieCutter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;

public final class MSMContent
extends RegistryDataProvider {
    public static final String MOD_ID = "msmlegacy";
    public static final Config CONFIG = Config.load();
    public static MSMContent INSTANCE;

    public static void init() {
        INSTANCE = new MSMContent();
        Services.REGISTRIES.loadContent((RegistryDataProvider)INSTANCE);
    }

    private MSMContent() {
        super(MOD_ID);
        this.withItemTab(() -> ((Item)BuiltInRegistries.ITEM.get(new ResourceLocation(MOD_ID, "relic_adminium_ark"))).getDefaultInstance());
        this.sword("dawn_star", Rarity.RARE, MSMContent.CONFIG.swordStats.dawnStar);
        this.sword("vampiric_blade", Rarity.RARE, MSMContent.CONFIG.swordStats.vampiricBlade);
        this.sword("gladiolus", Rarity.UNCOMMON, MSMContent.CONFIG.swordStats.gladiolus);
        this.sword("draconic_blade", Rarity.UNCOMMON, MSMContent.CONFIG.swordStats.draconicBlade);
        this.sword("eye_end_blade", Rarity.RARE, MSMContent.CONFIG.swordStats.eyeEndBlade);
        this.sword("crystaline_blade", Rarity.UNCOMMON, MSMContent.CONFIG.swordStats.crystalineBlade);
        this.sword("glacial_blade", Rarity.RARE, MSMContent.CONFIG.swordStats.glacialBlade);
        this.sword("aethers_guard", Rarity.EPIC, MSMContent.CONFIG.swordStats.aethersGuard);
        this.sword("wither_bane", Rarity.EPIC, MSMContent.CONFIG.swordStats.withersBane);
        this.enchantment("ignite", EnchantmentIgnite::new);
        this.enchantment("sparks", EnchantmentSparks::new);
        this.enchantment("feast", EnchantmentFeast::new);
        this.enchantment("vitality", EnchantmentVitality::new);
        this.enchantment("venomous_aspect", EnchantmentVenomousAspect::new);
        this.enchantment("absorb", EnchantmentAbsorb::new);
        this.enchantment("keen_edge", EnchantmentKeenEdge::new);
        this.enchantment("scorn", EnchantmentScorn::new);
        this.enchantment("ender_pulse", EnchantmentEnderPulse::new);
        this.enchantment("ender_aura", EnchantmentEnderAura::new);
        this.enchantment("greed", EnchantmentGreed::new);
        this.enchantment("wisdom", EnchantmentWisdom::new);
        this.enchantment("frozen_aspect", EnchantmentFrozenAspect::new);
        this.enchantment("frost_wave", EnchantmentFrostWave::new);
        this.enchantment("ascension", EnchantmentAscension::new);
        this.enchantment("skys_grace", EnchantmentSkysGrace::new);
        this.enchantment("decay", EnchantmentDecay::new);
        this.enchantment("consuming_shadows", EnchantmentConsumingShadows::new);
        this.relic("relic_aqueous_blade", 1, MSMContent.CONFIG.swordStats.relic_aqueous_blade);
        this.relic("relic_molten_blade", 2, MSMContent.CONFIG.swordStats.relic_molten_blade);
        this.relic("relic_infinity_blade", 3, MSMContent.CONFIG.swordStats.relic_infinity_blade);
        this.relic("relic_key_blade", 4, MSMContent.CONFIG.swordStats.relic_key_blade);
        this.relic("relic_master_sword", 5, MSMContent.CONFIG.swordStats.relic_master_sword);
        this.relic("relic_pie_cutter", 6, MSMContent.CONFIG.swordStats.relic_pie_cutter);
        this.relic("relic_blaze_sword", 7, MSMContent.CONFIG.swordStats.relic_blaze_sword);
        this.relic("relic_adminium_ark", 8, MSMContent.CONFIG.swordStats.relic_adminium_ark);
        if (MSMContent.CONFIG.relics.pieCutterConfig.isEnabled()) {
            this.trades.addRareWanderingTrade((VillagerTrades.ItemListing)new MerchantOfferPieCutter());
        }
    }

    private void sword(String name, Rarity rarity, SwordStatsConfig config) {
        this.items.add(() -> new MSMSwordItem(name, rarity, config), name);
    }

    private void relic(String name, int index, SwordStatsConfig config) {
        this.items.add(() -> new RelicSwordItem(name, index, config), name);
    }

    private void enchantment(String name, Function<String, Enchantment> constructor) {
        this.enchantments.add(() -> (Enchantment)constructor.apply(name), name);
    }
}

