/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy.item;

import java.util.Map;
import net.darkhax.msmlegacy.config.SwordStatsConfig;
import net.darkhax.msmlegacy.enchantments.SwordEnchantment;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class MSMSwordItem
extends SwordItem {
    private final TagKey<Item> repairMaterialTag;
    private final Ingredient repairMaterials;

    public MSMSwordItem(String type, Rarity rarity, SwordStatsConfig config) {
        super(config.getAstier(), 0, config.swingSpeedPenalty, new Item.Properties().stacksTo(1).rarity(rarity));
        this.repairMaterialTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation("msmlegacy", "repair/" + type));
        this.repairMaterials = Ingredient.of(this.repairMaterialTag);
    }

    public boolean isValidRepairItem(ItemStack self, ItemStack material) {
        return this.repairMaterials.test(material);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity user, int slotId, boolean isSelected) {
        if (isSelected && user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            for (Map.Entry enchData : EnchantmentHelper.getEnchantments((ItemStack)stack).entrySet()) {
                Object k = enchData.getKey();
                if (!(k instanceof SwordEnchantment)) continue;
                SwordEnchantment swordEnchantment = (SwordEnchantment)((Object)k);
                swordEnchantment.onHeldTick(stack, level, (Player)serverPlayer, slotId, (Integer)enchData.getValue());
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack usedStack = player.getItemInHand(hand);
        for (Map.Entry enchData : EnchantmentHelper.getEnchantments((ItemStack)usedStack).entrySet()) {
            SwordEnchantment swordEnchantment;
            InteractionResultHolder<ItemStack> result;
            Object k = enchData.getKey();
            if (!(k instanceof SwordEnchantment) || (result = (swordEnchantment = (SwordEnchantment)((Object)k)).onItemUsed(level, player, hand, (Integer)enchData.getValue())) == null) continue;
            return result;
        }
        return super.use(level, player, hand);
    }

    public final Ingredient getRepairMaterials() {
        return this.repairMaterials;
    }
}

