/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy.enchantments;

import java.util.Optional;
import javax.annotation.Nullable;
import net.darkhax.msmlegacy.config.types.EnchantmentConfig;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;

public class SwordEnchantment
extends Enchantment {
    private final EnchantmentConfig config;
    private final TagKey<Enchantment> incompatibleEnchantments;
    private final TagKey<Item> compatibleItems;

    public SwordEnchantment(Enchantment.Rarity rarity, String type, EnchantmentConfig config) {
        super(rarity, EnchantmentCategory.WEAPON, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
        this.config = config;
        this.incompatibleEnchantments = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)new ResourceLocation("msmlegacy", "compatibility/incompatible_with_" + type));
        this.compatibleItems = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation("msmlegacy", "compatibility/compatible_with_" + type));
    }

    public int getMinLevel() {
        return this.config.minLevel;
    }

    public int getMaxLevel() {
        return this.config.maxLevel;
    }

    public boolean isTradeable() {
        return this.config.isTradeable;
    }

    public boolean isDiscoverable() {
        return this.config.isDiscoverable;
    }

    public boolean checkCompatibility(Enchantment other) {
        Optional holder;
        ResourceLocation enchantmentId = BuiltInRegistries.ENCHANTMENT.getKey((Object)other);
        if (enchantmentId != null && (holder = BuiltInRegistries.ENCHANTMENT.getHolder(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)enchantmentId))) != null && holder.isPresent()) {
            return !((Holder.Reference)holder.get()).is(this.incompatibleEnchantments);
        }
        return false;
    }

    @Nullable
    public InteractionResultHolder<ItemStack> onItemUsed(Level worldLevel, Player player, InteractionHand hand, int level) {
        return null;
    }

    public void onHeldTick(ItemStack stack, Level level, Player user, int slotId, int enchLevel) {
    }

    public Component getName() {
        return Component.translatable((String)this.getDescriptionId());
    }

    public boolean canEnchant(ItemStack item) {
        return item.is(this.compatibleItems);
    }
}

