/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy.enchantments;

import javax.annotation.Nullable;
import net.darkhax.msmlegacy.MSMContent;
import net.darkhax.msmlegacy.config.enchantment.VitalityConfig;
import net.darkhax.msmlegacy.enchantments.SwordEnchantment;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class EnchantmentVitality
extends SwordEnchantment {
    public EnchantmentVitality(String type) {
        super(Enchantment.Rarity.UNCOMMON, type, MSMContent.CONFIG.enchantments.vitality);
    }

    @Override
    @Nullable
    public InteractionResultHolder<ItemStack> onItemUsed(Level worldLevel, Player player, InteractionHand hand, int level) {
        int durabilityCost;
        VitalityConfig config = MSMContent.CONFIG.enchantments.vitality;
        ItemStack stack = player.getItemInHand(hand);
        int remainingDurability = stack.getMaxDamage() - stack.getDamageValue();
        if (remainingDurability > (durabilityCost = (int)((float)stack.getMaxDamage() * config.durabilityCost.getValue(level)))) {
            stack.setDamageValue(stack.getDamageValue() + durabilityCost);
            config.absorption.applyEffect((Entity)player, level);
            config.resistance.applyEffect((Entity)player, level);
            config.regeneration.applyEffect((Entity)player, level);
            config.fireResistance.applyEffect((Entity)player, level);
            player.heal((float)config.healAmount.getValue(level));
            worldLevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WARDEN_HEARTBEAT, player.getSoundSource(), 1.0f, 0.5f);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"enchantment.msmlegacy.vitality.not_enough_durability"), true);
        }
        return super.onItemUsed(worldLevel, player, hand, level);
    }
}

