/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy.config.types;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public class LevelScaledFloat {
    public static final TypeAdapter<LevelScaledFloat> ADAPTER = new Adapter();
    private float[] values;

    public float getValue(int level) {
        if (this.values.length == 1) {
            return this.values[0] * (float)level;
        }
        int valueIndex = level - 1;
        if (valueIndex < 0) {
            return this.values[0];
        }
        if (valueIndex > this.values.length - 1) {
            return this.values[this.values.length - 1];
        }
        return this.values[valueIndex];
    }

    public LevelScaledFloat(float f) {
        this(new float[]{f});
    }

    public LevelScaledFloat(float[] values) {
        this.values = values;
    }

    public static class Adapter
    extends TypeAdapter<LevelScaledFloat> {
        public void write(JsonWriter out, LevelScaledFloat value) throws IOException {
            if (value.values.length == 1) {
                out.value(value.values[0]);
            } else {
                out.beginArray();
                for (float fval : value.values) {
                    out.value(fval);
                }
                out.endArray();
            }
        }

        public LevelScaledFloat read(JsonReader in) throws IOException {
            if (in.hasNext()) {
                JsonToken type = in.peek();
                if (type == JsonToken.BEGIN_ARRAY) {
                    ArrayList<Float> values = new ArrayList<Float>();
                    in.beginArray();
                    while (in.hasNext()) {
                        values.add(Float.valueOf((float)in.nextDouble()));
                    }
                    in.endArray();
                    return new LevelScaledFloat(ArrayUtils.toPrimitive((Float[])values.toArray(new Float[0])));
                }
                return new LevelScaledFloat((float)in.nextDouble());
            }
            throw new JsonParseException("Value expected to be a float or float array.");
        }
    }
}

