/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy.config.types;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public class LevelScaledDouble {
    public static final TypeAdapter<LevelScaledDouble> ADAPTER = new Adapter();
    private double[] values;

    public double getValue(int level) {
        if (this.values.length == 1) {
            return this.values[0] * (double)level;
        }
        int valueIndex = level - 1;
        if (valueIndex < 0) {
            return this.values[0];
        }
        if (valueIndex > this.values.length - 1) {
            return this.values[this.values.length - 1];
        }
        return this.values[valueIndex];
    }

    public LevelScaledDouble(double f) {
        this(new double[]{f});
    }

    public LevelScaledDouble(double[] values) {
        this.values = values;
    }

    public static class Adapter
    extends TypeAdapter<LevelScaledDouble> {
        public void write(JsonWriter out, LevelScaledDouble value) throws IOException {
            if (value.values.length == 1) {
                out.value(value.values[0]);
            } else {
                out.beginArray();
                for (double fval : value.values) {
                    out.value(fval);
                }
                out.endArray();
            }
        }

        public LevelScaledDouble read(JsonReader in) throws IOException {
            if (in.hasNext()) {
                JsonToken type = in.peek();
                if (type == JsonToken.BEGIN_ARRAY) {
                    ArrayList<Double> values = new ArrayList<Double>();
                    in.beginArray();
                    while (in.hasNext()) {
                        values.add(in.nextDouble());
                    }
                    in.endArray();
                    return new LevelScaledDouble(ArrayUtils.toPrimitive((Double[])values.toArray(new Double[0])));
                }
                return new LevelScaledDouble(in.nextDouble());
            }
            throw new JsonParseException("Value expected to be a double or double array.");
        }
    }
}

