/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy.config.adapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;

public class RegistryTypeAdapter<T>
extends TypeAdapter<T> {
    public static RegistryTypeAdapter<MobEffect> MOB_EFFECT = new RegistryTypeAdapter(BuiltInRegistries.MOB_EFFECT);
    private final Registry<T> registry;

    public RegistryTypeAdapter(Registry<T> registry) {
        this.registry = registry;
    }

    public void write(JsonWriter out, T value) throws IOException {
        ResourceLocation id = this.registry.getKey(value);
        if (id == null || !this.registry.containsKey(id)) {
            throw new IOException("Value does not exist in registry. " + value);
        }
        out.value(id.toString());
    }

    public T read(JsonReader in) throws IOException {
        String rawId = in.nextString();
        ResourceLocation id = ResourceLocation.tryParse((String)rawId);
        if (id != null && this.registry.containsKey(id)) {
            return (T)this.registry.get(id);
        }
        throw new IOException("Value does not exist in registry. " + rawId);
    }
}

