/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.msmlegacy.config;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;

public class SwordStatsConfig {
    @Expose
    @SerializedName(value="harvest_level")
    public int harvestLevel = 3;
    @Expose
    @SerializedName(value="durability")
    public int durability;
    @Expose
    @SerializedName(value="dig_speed")
    public float digSpeed = 1.0f;
    @Expose
    @SerializedName(value="attack_damage")
    public float damage;
    @Expose
    @SerializedName(value="enchantability")
    public int enchantability;
    @Expose
    @SerializedName(value="swing_speed_penalty")
    public float swingSpeedPenalty = -2.4f;

    public SwordStatsConfig(int durability, float attackDamage, int enchantability) {
        this.durability = durability;
        this.damage = attackDamage;
        this.enchantability = enchantability;
    }

    public SwordStatsConfig(int durability, float attackDamage) {
        this(durability, attackDamage, 14);
    }

    public SwordStatsConfig swingSpeed(float speed) {
        this.swingSpeedPenalty = speed;
        return this;
    }

    public Tier getAstier() {
        return new SwordTier(this);
    }

    public static class SwordTier
    implements Tier {
        private SwordStatsConfig config;

        public SwordTier(SwordStatsConfig config) {
            this.config = config;
        }

        public int getUses() {
            return this.config.durability;
        }

        public float getSpeed() {
            return this.config.digSpeed;
        }

        public float getAttackDamageBonus() {
            return Math.max(0.0f, this.config.damage - 1.0f);
        }

        public int getLevel() {
            return this.config.harvestLevel;
        }

        public int getEnchantmentValue() {
            return this.config.enchantability;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.EMPTY;
        }
    }
}

