/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.ghostgear.common.impl.spiritbox;

import com.mojang.serialization.MapCodec;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.ghostgear.common.impl.GhostGear;
import net.darkhax.ghostgear.common.impl.spiritbox.SpiritBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SpiritBoxBlock
extends BaseEntityBlock {
    public static final CachedSupplier<Block> TYPE = CachedSupplier.of((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)GhostGear.id("spirit_box"));
    private static final VoxelShape COLLISION_X = Block.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)10.0, (double)13.0);
    private static final VoxelShape COLLISION_Z = Block.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)10.0, (double)12.0);

    public SpiritBoxBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).instrument(NoteBlockInstrument.BASS).strength(2.0f, 6.0f).sound(SoundType.WOOD).ignitedByLava());
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        this.openMenu(state, level, pos, player);
        return ItemInteractionResult.CONSUME;
    }

    public void openMenu(BlockState state, Level level, BlockPos pos, Player player) {
        MenuProvider menuprovider = this.getMenuProvider(state, level, pos);
        if (menuprovider != null) {
            player.openMenu(menuprovider);
        }
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() != Direction.Axis.Z ? COLLISION_X : COLLISION_Z;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new SpiritBoxBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return SpiritBoxBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SpiritBoxBlockEntity.TYPE.get()), SpiritBoxBlockEntity::tickBox);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }
}

