package net.darkhax.ghostgear.common.impl.spiritbox;

import net.darkhax.ghostgear.common.impl.GhostGear;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class SpiritBoxScreen extends class_465<SpiritBoxMenu> {

    private static final class_2960 TEXTURE = GhostGear.id("textures/gui/spirit_box.png");

    private class_4185 modeButton;
    private class_4185 speedButton;

    public SpiritBoxScreen(SpiritBoxMenu menu, class_1661 playerInv, class_2561 title) {
        super(menu, playerInv, title);
        this.field_2792 = 176;
        this.field_2779 = 166;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        final int centerX = (this.field_22789 - this.field_2792) / 2;
        final int centerY = (this.field_22790 - this.field_2779) / 2;
        modeButton = class_4185.method_46430(field_2797.getScanMode().displayName(), this::onModeClicked).method_46436(class_7919.method_47407(field_2797.getScanMode().description())).method_46433(centerX + 10, centerY + 40).method_46437(150, 20).method_46431();
        speedButton = class_4185.method_46430(field_2797.getScanSpeed().displayName(), this::onSpeedClicked).method_46436(class_7919.method_47407(field_2797.getScanSpeed().description())).method_46433(centerX + 10, centerY + 70).method_46437(150, 20).method_46431();
        method_37063(modeButton);
        method_37063(speedButton);
        this.field_2797.method_7596(new class_1712() {
            @Override
            public void method_7635(@NotNull class_1703 menu, int slot, @NotNull class_1799 stack) {
                // NO-OP
            }

            @Override
            public void method_7633(@NotNull class_1703 menu, int slot, int value) {
                switch (slot) {
                    case 0 -> {
                        final ScanMode mode = ScanMode.values()[value];
                        modeButton.method_25355(mode.displayName());
                        modeButton.method_47400(class_7919.method_47407(mode.description()));
                    }
                    case 1 -> {
                        final ScanSpeed speed = ScanSpeed.values()[value];
                        speedButton.method_25355(speed.displayName());
                        speedButton.method_47400(class_7919.method_47407(speed.description()));
                    }
                }
            }
        });
    }

    @Override
    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0xffffff, false);
    }

    private void onModeClicked(class_4185 button) {
        field_2797.cycleScanMode();
        clickMenuButton(0);
        button.method_25355(field_2797.getScanMode().displayName());
    }

    private void onSpeedClicked(class_4185 button) {
        field_2797.cycleScanSpeed();
        clickMenuButton(1);
        button.method_25355(field_2797.getScanSpeed().displayName());
    }

    private void clickMenuButton(int buttonId) {
        if (this.field_22787 != null && this.field_22787.field_1761 != null) {
            this.field_22787.field_1761.method_2900(this.field_2797.field_7763, buttonId);
        }
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTick, int mouseX, int mouseY) {
        final int x = (this.field_22789 - this.field_2792) / 2;
        final int y = (this.field_22790 - this.field_2779) / 2;
        graphics.method_25302(TEXTURE, x, y, 0, 0, this.field_2792, this.field_2779);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics, mouseX, mouseY, delta);
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
    }
}