package net.darkhax.ghostgear.common.impl;

import net.darkhax.bookshelf.common.api.registry.ContentProvider;
import net.darkhax.bookshelf.common.api.registry.RegistryReference;
import net.darkhax.bookshelf.common.api.registry.adapters.GameRegistryAdapter;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRegistryAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuScreenAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.SoundEventAdapter;
import net.darkhax.ghostgear.common.impl.spiritbox.Dictionaries;
import net.darkhax.ghostgear.common.impl.spiritbox.SpiritBoxBlock;
import net.darkhax.ghostgear.common.impl.spiritbox.SpiritBoxBlockEntity;
import net.darkhax.ghostgear.common.impl.spiritbox.SpiritBoxMenu;
import net.darkhax.ghostgear.common.impl.spiritbox.SpiritBoxScreen;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_5321;

public class Content implements ContentProvider {

    private RegistryReference<class_5321<class_2248>, class_2248> spiritBoxBlock;

    @Override
    public void defineBlocks(BlockRegistryAdapter registry) {
        this.spiritBoxBlock = registry.addPlaceable("spirit_box", SpiritBoxBlock::new);
    }

    @Override
    public void defineMenuType(MenuTypeAdapter registry) {
        registry.add("spirit_box", SpiritBoxMenu::clientMenu);
    }

    @Override
    public void defineMenuScreens(MenuScreenAdapter registry) {
        registry.bind(SpiritBoxMenu.TYPE.get(), SpiritBoxScreen::new);
    }

    @Override
    public void defineBlockEntities(GameRegistryAdapter<class_2591<?>> registry) {
        registry.add("spirit_box", Services.GAMEPLAY.blockEntityBuilder(SpiritBoxBlockEntity::new, new class_2248[]{spiritBoxBlock.value().get()}).method_11034(null));
    }

    @Override
    public void defineSounds(SoundEventAdapter registry) {
        for (String word : Dictionaries.ALL_WORDS) {
            registry.variableRange("ghostgear.spirit_box." + word);
        }
    }

    @Override
    public String namespace() {
        return GhostGear.MOD_ID;
    }
}