/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.ghostgear.common.impl.spiritbox;

import java.util.Objects;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.ghostgear.common.impl.GhostGear;
import net.darkhax.ghostgear.common.impl.spiritbox.ScanMode;
import net.darkhax.ghostgear.common.impl.spiritbox.ScanSpeed;
import net.darkhax.ghostgear.common.impl.spiritbox.SpiritBoxBlock;
import net.darkhax.ghostgear.common.impl.spiritbox.SpiritBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpiritBoxMenu
extends AbstractContainerMenu {
    public static final CachedSupplier<MenuType<SpiritBoxMenu>> TYPE = CachedSupplier.cache(() -> (MenuType)BuiltInRegistries.MENU.get(GhostGear.id("spirit_box"))).cast();
    private final ContainerLevelAccess levelAccess;
    private final ContainerData data;

    public static SpiritBoxMenu clientMenu(int containerId, Inventory playerInv) {
        return new SpiritBoxMenu((MenuType)TYPE.get(), containerId, (ContainerData)new SimpleContainerData(2), ContainerLevelAccess.NULL);
    }

    public static SpiritBoxMenu serverMenu(int containerId, Inventory playerInv, SpiritBoxBlockEntity box) {
        return new SpiritBoxMenu((MenuType)TYPE.get(), containerId, box.getDataAccess(), ContainerLevelAccess.create((Level)Objects.requireNonNull(box.getLevel()), (BlockPos)box.getBlockPos()));
    }

    protected SpiritBoxMenu(@Nullable MenuType<?> menuType, int containerId, ContainerData boxData, ContainerLevelAccess levelAccess) {
        super(menuType, containerId);
        this.levelAccess = levelAccess;
        this.data = boxData;
        this.addDataSlots(boxData);
    }

    public void cycleScanMode() {
        this.setScanMode(SpiritBoxMenu.cycleEnum(this.getScanMode(), ScanMode.class, true));
    }

    public ScanMode getScanMode() {
        return ScanMode.values()[this.data.get(0)];
    }

    public void setScanMode(ScanMode scanMode) {
        this.setData(0, scanMode.ordinal());
    }

    public void cycleScanSpeed() {
        this.setScanSpeed(SpiritBoxMenu.cycleEnum(this.getScanSpeed(), ScanSpeed.class, true));
    }

    public void setScanSpeed(ScanSpeed scanSpeed) {
        this.setData(1, scanSpeed.ordinal());
    }

    public ScanSpeed getScanSpeed() {
        return ScanSpeed.values()[this.data.get(1)];
    }

    public void setData(int id, int value) {
        super.setData(id, value);
        this.broadcastFullState();
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int i) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return SpiritBoxMenu.stillValid((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)SpiritBoxBlock.TYPE.get()));
    }

    public boolean clickMenuButton(Player player, int id) {
        switch (id) {
            case 0: {
                this.cycleScanMode();
                break;
            }
            case 1: {
                this.cycleScanSpeed();
            }
        }
        return true;
    }

    public static <T extends Enum<T>> T cycleEnum(T current, Class<T> enumClass, boolean forward) {
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        int index = current.ordinal() + (forward ? 1 : -1);
        if (index < 0) {
            index = values.length - 1;
        }
        if (index >= values.length) {
            index = 0;
        }
        return (T)values[index];
    }
}

