/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.ghostgear.common.impl;

import net.darkhax.bookshelf.common.api.registry.ContentProvider;
import net.darkhax.bookshelf.common.api.registry.RegistryReference;
import net.darkhax.bookshelf.common.api.registry.adapters.GameRegistryAdapter;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRegistryAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuScreenAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.SoundEventAdapter;
import net.darkhax.ghostgear.common.impl.spiritbox.Dictionaries;
import net.darkhax.ghostgear.common.impl.spiritbox.SpiritBoxBlock;
import net.darkhax.ghostgear.common.impl.spiritbox.SpiritBoxBlockEntity;
import net.darkhax.ghostgear.common.impl.spiritbox.SpiritBoxMenu;
import net.darkhax.ghostgear.common.impl.spiritbox.SpiritBoxScreen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class Content
implements ContentProvider {
    private RegistryReference<ResourceKey<Block>, Block> spiritBoxBlock;

    public void defineBlocks(BlockRegistryAdapter registry) {
        this.spiritBoxBlock = registry.addPlaceable("spirit_box", SpiritBoxBlock::new);
    }

    public void defineMenuType(MenuTypeAdapter registry) {
        registry.add("spirit_box", SpiritBoxMenu::clientMenu);
    }

    public void defineMenuScreens(MenuScreenAdapter registry) {
        registry.bind((MenuType)SpiritBoxMenu.TYPE.get(), SpiritBoxScreen::new);
    }

    public void defineBlockEntities(GameRegistryAdapter<BlockEntityType<?>> registry) {
        registry.add("spirit_box", (Object)Services.GAMEPLAY.blockEntityBuilder(SpiritBoxBlockEntity::new, new Block[]{(Block)this.spiritBoxBlock.value().get()}).build(null));
    }

    public void defineSounds(SoundEventAdapter registry) {
        for (String word : Dictionaries.ALL_WORDS) {
            registry.variableRange("ghostgear.spirit_box." + word);
        }
    }

    public String namespace() {
        return "ghostgear";
    }
}

