package net.darkhax.ghostgear.common.impl.spiritbox;

import net.darkhax.ghostgear.common.impl.GhostGear;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SpiritBoxScreen extends AbstractContainerScreen<SpiritBoxMenu> {

    private static final ResourceLocation TEXTURE = GhostGear.id("textures/gui/spirit_box.png");

    private Button modeButton;
    private Button speedButton;

    public SpiritBoxScreen(SpiritBoxMenu menu, Inventory playerInv, Component title) {
        super(menu, playerInv, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    protected void init() {
        super.init();
        final int centerX = (this.width - this.imageWidth) / 2;
        final int centerY = (this.height - this.imageHeight) / 2;
        modeButton = Button.builder(menu.getScanMode().displayName(), this::onModeClicked).tooltip(Tooltip.create(menu.getScanMode().description())).pos(centerX + 10, centerY + 40).size(150, 20).build();
        speedButton = Button.builder(menu.getScanSpeed().displayName(), this::onSpeedClicked).tooltip(Tooltip.create(menu.getScanSpeed().description())).pos(centerX + 10, centerY + 70).size(150, 20).build();
        addRenderableWidget(modeButton);
        addRenderableWidget(speedButton);
        this.menu.addSlotListener(new ContainerListener() {
            @Override
            public void slotChanged(@NotNull AbstractContainerMenu menu, int slot, @NotNull ItemStack stack) {
                // NO-OP
            }

            @Override
            public void dataChanged(@NotNull AbstractContainerMenu menu, int slot, int value) {
                switch (slot) {
                    case 0 -> {
                        final ScanMode mode = ScanMode.values()[value];
                        modeButton.setMessage(mode.displayName());
                        modeButton.setTooltip(Tooltip.create(mode.description()));
                    }
                    case 1 -> {
                        final ScanSpeed speed = ScanSpeed.values()[value];
                        speedButton.setMessage(speed.displayName());
                        speedButton.setTooltip(Tooltip.create(speed.description()));
                    }
                }
            }
        });
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0xffffff, false);
    }

    private void onModeClicked(Button button) {
        menu.cycleScanMode();
        clickMenuButton(0);
        button.setMessage(menu.getScanMode().displayName());
    }

    private void onSpeedClicked(Button button) {
        menu.cycleScanSpeed();
        clickMenuButton(1);
        button.setMessage(menu.getScanSpeed().displayName());
    }

    private void clickMenuButton(int buttonId) {
        if (this.minecraft != null && this.minecraft.gameMode != null) {
            this.minecraft.gameMode.handleInventoryButtonClick(this.menu.containerId, buttonId);
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        final int x = (this.width - this.imageWidth) / 2;
        final int y = (this.height - this.imageHeight) / 2;
        graphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }
}