package net.darkhax.ghostgear.common.impl.spiritbox;

import net.darkhax.ghostgear.common.impl.GhostGear;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;

public enum ScanMode {

    WORDS("spirit_box/all_words"),
    ANSWERS("spirit_box/answers"),
    ALPHANUMERIC("spirit_box/alphanumeric");

    private final TagKey<SoundEvent> sounds;
    private final Component displayName;
    private final Component description;

    ScanMode(String soundTag) {
        this.sounds = TagKey.create(Registries.SOUND_EVENT, GhostGear.id(soundTag));
        this.displayName = Component.translatable("ghostgear.spirit_box.scan_mode." + this.name().toLowerCase());
        this.description = Component.translatable("ghostgear.spirit_box.scan_mode." + this.name().toLowerCase() + ".desc");
    }

    public Component displayName() {
        return this.displayName;
    }

    public Component description() {
        return this.description;
    }

    public TagKey<SoundEvent> soundTag() {
        return this.sounds;
    }
}