/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.friendlyfire;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.friendlyfire.Config;
import net.darkhax.friendlyfire.Constants;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6025;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class FriendlyFireCommon {
    private static final class_6862<class_1792> BYPASS_PET = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("friendlyfire", "bypass_pet"));
    private static final class_6862<class_1792> BYPASS_ALL = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("friendlyfire", "bypass_all_protection"));
    private static final class_6862<class_1299<?>> GENERAL_PROTECTION = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960("friendlyfire", "general_protection"));
    private static final class_6862<class_1299<?>> PLAYER_PROTECTION = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960("friendlyfire", "player_protection"));
    private static final class_6862<class_1299<?>> BYPASSED_PROTECTION = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960("friendlyfire", "bypassed_entity_types"));
    private static final Config CONFIG = Config.load(new File(Services.PLATFORM.getConfigDirectory(), "friendlyfire.json"));

    public static void init() {
        Constants.LOG.debug("Protect children = {}", (Object)FriendlyFireCommon.CONFIG.protectChildren);
        Constants.LOG.debug("Protect pets from owner = {}", (Object)FriendlyFireCommon.CONFIG.protectPetsFromOwner);
        Constants.LOG.debug("Protect pets from pets = {}", (Object)FriendlyFireCommon.CONFIG.protectPetsFromPets);
        Constants.LOG.debug("Reflect damage = {}", (Object)FriendlyFireCommon.CONFIG.reflectDamage);
    }

    public static boolean preventAttack(class_1297 target, class_1282 source, float amount) {
        boolean preventDamage;
        class_1297 attacker = source.method_5529();
        boolean bl = preventDamage = source != null && FriendlyFireCommon.isProtected(target, attacker, amount);
        if (preventDamage && attacker instanceof class_3222) {
            class_3222 player = (class_3222)attacker;
            if (FriendlyFireCommon.CONFIG.displayHitWarning) {
                player.method_7353((class_2561)class_2561.method_43469((String)"notif.friendlyfire.protected", (Object[])new Object[]{target.method_5477()}), true);
            }
        }
        return preventDamage;
    }

    private static boolean isProtected(class_1297 victim, class_1297 attacker, float amount) {
        class_1296 agable;
        UUID ownerId;
        class_1799 heldItem;
        if (victim.method_5864().method_20210(BYPASSED_PROTECTION)) {
            return false;
        }
        if (victim == null || attacker == null || attacker.method_18276()) {
            return false;
        }
        if (attacker instanceof class_1309) {
            class_1309 attackerLiving = (class_1309)attacker;
            v0 = attackerLiving.method_6047();
        } else {
            v0 = heldItem = class_1799.field_8037;
        }
        if (heldItem.method_31573(BYPASS_ALL)) {
            return false;
        }
        if (victim.method_5864().method_20210(GENERAL_PROTECTION)) {
            return true;
        }
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            if (victim.method_5864().method_20210(PLAYER_PROTECTION)) {
                return true;
            }
        }
        if ((ownerId = FriendlyFireCommon.getOwner(victim)) != null && !heldItem.method_31573(BYPASS_PET)) {
            if (FriendlyFireCommon.CONFIG.protectPetsFromOwner && ownerId.equals(attacker.method_5667())) {
                if (FriendlyFireCommon.CONFIG.reflectDamage) {
                    attacker.method_5643(attacker.method_37908().method_48963().method_48830(), amount);
                }
                return true;
            }
            if (FriendlyFireCommon.CONFIG.protectPetsFromPets && ownerId.equals(FriendlyFireCommon.getOwner(attacker))) {
                return true;
            }
        }
        if (FriendlyFireCommon.CONFIG.protectTeamMembers && FriendlyFireCommon.isOnProtectedTeam(attacker, victim)) {
            return true;
        }
        return FriendlyFireCommon.CONFIG.protectChildren && attacker instanceof class_1657 && !(victim instanceof class_1569) && victim instanceof class_1296 && (agable = (class_1296)victim).method_6109() && !attacker.method_18276();
    }

    private static boolean isOnProtectedTeam(class_1297 attacker, class_1297 victim) {
        class_268 attackerTeam = FriendlyFireCommon.getEffectiveTeam(attacker);
        class_268 victimTeam = FriendlyFireCommon.getEffectiveTeam(victim);
        return attackerTeam != null && victimTeam != null && attackerTeam.method_1206((class_270)victimTeam) && victimTeam.method_1206((class_270)attackerTeam) && (!FriendlyFireCommon.CONFIG.respectTeamRules || !victimTeam.method_1205());
    }

    @Nullable
    private static class_268 getEffectiveTeam(class_1297 entity) {
        class_6025 ownable;
        class_268 directTeam = entity.method_5781();
        if (directTeam == null && entity instanceof class_6025 && (ownable = (class_6025)entity).method_6139() != null) {
            class_3218 server;
            GameProfile fetchResult;
            if (ownable.method_35057() != null) {
                return ownable.method_35057().method_5781();
            }
            class_1937 class_19372 = entity.method_37908();
            if (class_19372 instanceof class_3218 && (fetchResult = (GameProfile)(server = (class_3218)class_19372).method_8503().method_3793().method_14512(ownable.method_6139()).orElse(null)) != null) {
                return entity.method_37908().method_8428().method_1164(fetchResult.getName());
            }
        }
        return directTeam;
    }

    @Nullable
    private static UUID getOwner(class_1297 entity) {
        if (entity instanceof class_6025) {
            class_6025 ownable = (class_6025)entity;
            return ownable.method_6139();
        }
        if (entity instanceof class_1496) {
            class_1496 horse = (class_1496)entity;
            return horse.method_6139();
        }
        return null;
    }
}

