package net.darkhax.friendlyfire;

import com.mojang.authlib.GameProfile;
import net.darkhax.bookshelf.api.Services;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6025;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import javax.annotation.Nullable;
import java.io.File;
import java.util.UUID;

public class FriendlyFireCommon {

    private static final class_6862<class_1792> BYPASS_PET = class_6862.method_40092(class_7924.field_41197, new class_2960("friendlyfire", "bypass_pet"));
    private static final class_6862<class_1792> BYPASS_ALL = class_6862.method_40092(class_7924.field_41197, new class_2960("friendlyfire", "bypass_all_protection"));
    private static final class_6862<class_1299<?>> GENERAL_PROTECTION = class_6862.method_40092(class_7924.field_41266, new class_2960("friendlyfire", "general_protection"));
    private static final class_6862<class_1299<?>> PLAYER_PROTECTION = class_6862.method_40092(class_7924.field_41266, new class_2960("friendlyfire", "player_protection"));
    private static final class_6862<class_1299<?>> BYPASSED_PROTECTION = class_6862.method_40092(class_7924.field_41266, new class_2960("friendlyfire", "bypassed_entity_types"));

    private static final Config CONFIG = Config.load(new File(Services.PLATFORM.getConfigDirectory(), "friendlyfire.json"));

    public static void init() {

        Constants.LOG.debug("Protect children = {}", CONFIG.protectChildren);
        Constants.LOG.debug("Protect pets from owner = {}", CONFIG.protectPetsFromOwner);
        Constants.LOG.debug("Protect pets from pets = {}", CONFIG.protectPetsFromPets);
        Constants.LOG.debug("Reflect damage = {}", CONFIG.reflectDamage);
    }

    public static boolean preventAttack(class_1297 target, class_1282 source, float amount) {

        final class_1297 attacker = source.method_5529();
        final boolean preventDamage = source != null && isProtected(target, attacker, amount);

        if (preventDamage && attacker instanceof class_3222 player && CONFIG.displayHitWarning) {

            player.method_7353(class_2561.method_43469("notif.friendlyfire.protected", target.method_5477()), true);
        }

        return preventDamage;
    }

    private static boolean isProtected(class_1297 victim, class_1297 attacker, float amount) {

        if (victim.method_5864().method_20210(BYPASSED_PROTECTION)) {

            return false;
        }

        // Null targets or sources can not be protected. Sneaking will bypass this mod
        // entirely.
        if (victim == null || attacker == null || attacker.method_18276()) {

            return false;
        }

        // The item used by the attacker.
        final class_1799 heldItem = attacker instanceof class_1309 attackerLiving ? attackerLiving.method_6047() : class_1799.field_8037;

        // Items in the bypass all tag will always cause damage.
        if (heldItem.method_31573(BYPASS_ALL)) {

            return false;
        }

        // Mobs with general protection tag are almost always protected.
        if (victim.method_5864().method_20210(GENERAL_PROTECTION)) {

            return true;
        }

        // Mobs with player protection are protected from players.
        if (attacker instanceof class_1657 player && victim.method_5864().method_20210(PLAYER_PROTECTION)) {

            return true;
        }

        // Gets the pet owner ID, will be null if not a pet mob.
        final UUID ownerId = getOwner(victim);

        if (ownerId != null && !heldItem.method_31573(BYPASS_PET)) {

            // Protects owners from hurting their pets.
            if (CONFIG.protectPetsFromOwner && ownerId.equals(attacker.method_5667())) {

                // Reflection causes players to hurt themselves instead.
                if (CONFIG.reflectDamage) {

                    attacker.method_5643(attacker.method_37908().method_48963().method_48830(), amount);
                }

                return true;
            }

            // Protect pets from pets with the same owner.
            else if (CONFIG.protectPetsFromPets && ownerId.equals(getOwner(attacker))) {

                return true;
            }
        }

        if (CONFIG.protectTeamMembers && isOnProtectedTeam(attacker, victim)) {

            return true;
        }

        // Check if child mobs can be killed.
        if (CONFIG.protectChildren && attacker instanceof class_1657 && !(victim instanceof class_1569) && victim instanceof class_1296 agable && agable.method_6109() && !attacker.method_18276()) {

            return true;
        }

        return false;
    }

    private static boolean isOnProtectedTeam(class_1297 attacker, class_1297 victim) {

        final class_268 attackerTeam = getEffectiveTeam(attacker);
        final class_268 victimTeam = getEffectiveTeam(victim);
        return attackerTeam != null && victimTeam != null && (attackerTeam.method_1206(victimTeam) && victimTeam.method_1206(attackerTeam)) && (!CONFIG.respectTeamRules || !victimTeam.method_1205());
    }

    @Nullable
    private static class_268 getEffectiveTeam(class_1297 entity) {

        final class_268 directTeam = entity.method_5781();

        if (directTeam == null && entity instanceof class_6025 ownable && ownable.method_6139() != null) {

            if (ownable.method_35057() != null) {

                return ownable.method_35057().method_5781();
            }

            if (entity.method_37908() instanceof class_3218 server) {

                final GameProfile fetchResult = server.method_8503().method_3793().method_14512(ownable.method_6139()).orElse(null);

                if (fetchResult != null) {

                    return entity.method_37908().method_8428().method_1164(fetchResult.getName());
                }
            }
        }

        return directTeam;
    }

    @Nullable
    private static UUID getOwner(class_1297 entity) {

        if (entity instanceof class_6025 ownable) {

            return ownable.method_6139();
        }

        // Thanks Mojang
        if (entity instanceof class_1496 horse) {

            return horse.method_6139();
        }

        return null;
    }
}