/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.friendlyfire;

import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.friendlyfire.Config;
import net.darkhax.friendlyfire.Constants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FriendlyFireCommon {
    private static final TagKey<Item> BYPASS_PET = Services.TAGS.itemTag(new ResourceLocation("friendlyfire", "bypass_pet"));
    private static final TagKey<Item> BYPASS_ALL = Services.TAGS.itemTag(new ResourceLocation("friendlyfire", "bypass_all_protection"));
    private static final TagKey<EntityType<?>> GENERAL_PROTECTION = Services.TAGS.entityTag(new ResourceLocation("friendlyfire", "general_protection"));
    private static final TagKey<EntityType<?>> PLAYER_PROTECTION = Services.TAGS.entityTag(new ResourceLocation("friendlyfire", "player_protection"));
    private static final TagKey<EntityType<?>> BYPASSED_PROTECTION = Services.TAGS.entityTag(new ResourceLocation("friendlyfire", "bypassed_entity_types"));
    private static final Config CONFIG = Config.load(new File(Services.PLATFORM.getConfigDirectory(), "friendlyfire.json"));

    public static void init() {
        Constants.LOG.debug("Protect children = {}", (Object)FriendlyFireCommon.CONFIG.protectChildren);
        Constants.LOG.debug("Protect pets from owner = {}", (Object)FriendlyFireCommon.CONFIG.protectPetsFromOwner);
        Constants.LOG.debug("Protect pets from pets = {}", (Object)FriendlyFireCommon.CONFIG.protectPetsFromPets);
        Constants.LOG.debug("Reflect damage = {}", (Object)FriendlyFireCommon.CONFIG.reflectDamage);
    }

    public static boolean preventAttack(Entity target, DamageSource source, float amount) {
        boolean preventDamage;
        Entity attacker = source.getEntity();
        boolean bl = preventDamage = source != null && FriendlyFireCommon.isProtected(target, attacker, amount);
        if (preventDamage && attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            if (FriendlyFireCommon.CONFIG.displayHitWarning) {
                player.displayClientMessage((Component)Component.translatable((String)"notif.friendlyfire.protected", (Object[])new Object[]{target.getName()}), true);
            }
        }
        return preventDamage;
    }

    private static boolean isProtected(Entity target, Entity attacker, float amount) {
        AgeableMob agable;
        UUID ownerId;
        ItemStack heldItem;
        if (target.getType().is(BYPASSED_PROTECTION)) {
            return false;
        }
        if (target == null || attacker == null || attacker.isCrouching()) {
            return false;
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity attackerLiving = (LivingEntity)attacker;
            v0 = attackerLiving.getMainHandItem();
        } else {
            v0 = heldItem = ItemStack.EMPTY;
        }
        if (heldItem.is(BYPASS_ALL)) {
            return false;
        }
        if (target.getType().is(GENERAL_PROTECTION)) {
            return true;
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (target.getType().is(PLAYER_PROTECTION)) {
                return true;
            }
        }
        if ((ownerId = FriendlyFireCommon.getOwner(target)) != null && !heldItem.is(BYPASS_PET)) {
            if (FriendlyFireCommon.CONFIG.protectPetsFromOwner && ownerId.equals(attacker.getUUID())) {
                if (FriendlyFireCommon.CONFIG.reflectDamage) {
                    attacker.hurt(attacker.level().damageSources().generic(), amount);
                }
                return true;
            }
            if (FriendlyFireCommon.CONFIG.protectPetsFromPets && ownerId.equals(FriendlyFireCommon.getOwner(attacker))) {
                return true;
            }
        }
        return FriendlyFireCommon.CONFIG.protectChildren && !(target instanceof Enemy) && target instanceof AgeableMob && (agable = (AgeableMob)target).isBaby() && !attacker.isCrouching();
    }

    @Nullable
    private static UUID getOwner(Entity entity) {
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            return ownable.getOwnerUUID();
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            return horse.getOwnerUUID();
        }
        return null;
    }
}

