/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc.common.impl;

import java.util.function.Consumer;
import net.darkhax.enchdesc.common.api.ContextProvider;
import net.darkhax.enchdesc.common.impl.Config;
import net.darkhax.pricklemc.common.api.config.ConfigManager;
import net.darkhax.pricklemc.common.api.util.CachedSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public class EnchantmentDescriptionsMod {
    private static final String[] KEY_TYPES = new String[]{"desc", "description", "info"};
    public static final CachedSupplier<Config> config = CachedSupplier.cache(() -> (Config)ConfigManager.load((String)"enchdesc", (Object)new Config()));

    public static void setupContext(ItemStack stack) {
        if (EnchantmentDescriptionsMod.canDisplayDescription(stack) && EnchantmentDescriptionsMod.isKeybindConditionMet()) {
            ContextProvider provider;
            Object object = stack.getEnchantments();
            if (object instanceof ContextProvider) {
                provider = (ContextProvider)object;
                provider.enchdesc$setStack(stack);
            }
            if ((object = stack.get(DataComponents.STORED_ENCHANTMENTS)) instanceof ContextProvider) {
                provider = (ContextProvider)object;
                provider.enchdesc$setStack(stack);
            }
        }
    }

    public static void revertContext(ItemStack stack) {
        ContextProvider provider;
        Object object = stack.getEnchantments();
        if (object instanceof ContextProvider) {
            provider = (ContextProvider)object;
            provider.enchdesc$setStack(ItemStack.EMPTY);
        }
        if ((object = stack.get(DataComponents.STORED_ENCHANTMENTS)) instanceof ContextProvider) {
            provider = (ContextProvider)object;
            provider.enchdesc$setStack(ItemStack.EMPTY);
        }
    }

    public static boolean canDisplayDescription(ItemStack stack) {
        Config cfg = (Config)config.get();
        return !(!cfg.enabled || !EnchantmentDescriptionsMod.hasEnchantments(stack) || cfg.only_on_books && stack.getItem() != Items.ENCHANTED_BOOK || cfg.only_in_enchanting_table && !(Minecraft.getInstance().screen instanceof EnchantmentScreen));
    }

    public static Component getKeybindText() {
        return ((Config)EnchantmentDescriptionsMod.config.get()).activate_text;
    }

    public static boolean isKeybindConditionMet() {
        return !((Config)EnchantmentDescriptionsMod.config.get()).require_keybind || Screen.hasShiftDown();
    }

    private static boolean hasEnchantments(ItemStack stack) {
        return !((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty() || !((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty();
    }

    public static void insertDescriptions(Holder<Enchantment> enchantment, int level, Consumer<Component> lines) {
        MutableComponent description = EnchantmentDescriptionsMod.getDescription(enchantment, ((ResourceKey)enchantment.unwrapKey().orElseThrow()).location(), level);
        if (description != null) {
            Config cfg = (Config)config.get();
            ComponentUtils.mergeStyles((MutableComponent)description, (Style)cfg.style);
            lines.accept((Component)cfg.prefix.copy().append((Component)description).append(cfg.suffix));
        }
    }

    @Nullable
    private static MutableComponent getDescription(Holder<Enchantment> enchantment, ResourceLocation id, int level) {
        ComponentContents componentContents;
        MutableComponent description = EnchantmentDescriptionsMod.getDescription("enchantment." + id.getNamespace() + "." + id.getPath() + ".", level);
        if (description == null && (componentContents = ((Enchantment)enchantment.value()).description().getContents()) instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            description = EnchantmentDescriptionsMod.getDescription(translatable.getKey() + ".", level);
        }
        return description;
    }

    @Nullable
    private static MutableComponent getDescription(String baseKey, int level) {
        for (String keyType : KEY_TYPES) {
            String key = baseKey + keyType;
            if (I18n.exists((String)key)) {
                return Component.translatable((String)key);
            }
            if (!I18n.exists((String)(key = key + "." + level))) continue;
            return Component.translatable((String)key);
        }
        return null;
    }
}

