package net.darkhax.deathknell.common.impl.message;

import net.darkhax.deathknell.common.api.message.IDeathMessage;
import net.darkhax.deathknell.common.impl.DeathKnell;
import net.minecraft.class_2561;

/**
 * A death message implementation that produces death messages from a predetermined range of variants.
 */
public record DeathMessageRandom(String... keys) implements IDeathMessage {

    @Override
    public class_2561 getMessage(Object... args) {
        return class_2561.method_43469("message.deathknell." + keys[DeathKnell.RNG.nextInt(keys.length)], IDeathMessage.remapArgs(args));
    }

    @Override
    public class_2561 getSubMessage(String alt, Object... args) {
        return class_2561.method_43469("message.deathknell." + keys[DeathKnell.RNG.nextInt(keys.length)] + "." + alt, IDeathMessage.remapArgs(args));
    }
}