/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.common.features.flatblocks;

import java.util.function.Consumer;
import net.darkhax.darkutilities.common.features.flatblocks.BlockFlatTile;
import net.darkhax.darkutilities.common.features.flatblocks.CollisionEffectPush;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FlatTileEffects {
    private static final ResourceKey<DamageType> FAKE_PLAYER_DAMAGE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bookshelf", (String)"fake_player"));
    public static final BlockFlatTile.CollisionEffect PUSH_WEAK = new CollisionEffectPush(0.06);
    public static final BlockFlatTile.CollisionEffect PUSH_NORMAL = new CollisionEffectPush(0.3);
    public static final BlockFlatTile.CollisionEffect PUSH_STRONG = new CollisionEffectPush(1.5);
    public static final BlockFlatTile.CollisionEffect PUSH_ULTRA = new CollisionEffectPush(7.5);
    public static final BlockFlatTile.CollisionEffect DAMAGE_GENERIC = FlatTileEffects.livingEffect(e -> e.hurt(e.level().damageSources().generic(), 6.0f));
    public static final BlockFlatTile.CollisionEffect DAMAGE_MAIM = FlatTileEffects.livingEffect(e -> {
        if (e.getHealth() >= 2.0f) {
            e.hurt(e.level().damageSources().generic(), 1.0f);
        }
    });
    public static final BlockFlatTile.CollisionEffect DAMAGE_PLAYER = FlatTileEffects.livingEffect(e -> e.hurt(FlatTileEffects.getSource(e.level(), FAKE_PLAYER_DAMAGE), 6.0f));
    public static final BlockFlatTile.CollisionEffect SLOWNESS = FlatTileEffects.statusEffect((Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, 100, 1);
    public static final BlockFlatTile.CollisionEffect FATIGUE = FlatTileEffects.statusEffect((Holder<MobEffect>)MobEffects.DIG_SLOWDOWN, 100, 1);
    public static final BlockFlatTile.CollisionEffect DARKNESS = FlatTileEffects.statusEffect((Holder<MobEffect>)MobEffects.BLINDNESS, 100, 1);
    public static final BlockFlatTile.CollisionEffect HUNGER = FlatTileEffects.statusEffect((Holder<MobEffect>)MobEffects.HUNGER, 100, 0);
    public static final BlockFlatTile.CollisionEffect WEAKNESS = FlatTileEffects.statusEffect((Holder<MobEffect>)MobEffects.WEAKNESS, 100, 0);
    public static final BlockFlatTile.CollisionEffect POISON = FlatTileEffects.statusEffect((Holder<MobEffect>)MobEffects.POISON, 100, 0);
    public static final BlockFlatTile.CollisionEffect WITHER = FlatTileEffects.statusEffect((Holder<MobEffect>)MobEffects.WITHER, 100, 0);
    public static final BlockFlatTile.CollisionEffect GLOWING = FlatTileEffects.statusEffect((Holder<MobEffect>)MobEffects.GLOWING, 500, 1);
    public static final BlockFlatTile.CollisionEffect LEVITATION = FlatTileEffects.statusEffect((Holder<MobEffect>)MobEffects.LEVITATION, 100, 1);
    public static final BlockFlatTile.CollisionEffect UNLUCK = FlatTileEffects.statusEffect((Holder<MobEffect>)MobEffects.UNLUCK, 666, 1);
    public static final BlockFlatTile.CollisionEffect SLOWFALL = FlatTileEffects.statusEffect((Holder<MobEffect>)MobEffects.SLOW_FALLING, 100, 1);
    public static final BlockFlatTile.CollisionEffect OMEN = FlatTileEffects.statusEffect((Holder<MobEffect>)MobEffects.BAD_OMEN, 500, 0);
    public static final BlockFlatTile.CollisionEffect FROST = FlatTileEffects.livingEffect(e -> {
        if (e.canFreeze()) {
            e.hurt(e.level().damageSources().freeze(), 1.0f);
            int existingFrostTicks = e.getTicksFrozen();
            e.setTicksFrozen(Math.min(existingFrostTicks + 20, 80));
        }
    });
    public static final BlockFlatTile.CollisionEffect FLAME = FlatTileEffects.livingEffect(e -> {
        if (!e.fireImmune()) {
            e.hurt(e.level().damageSources().inFire(), 1.0f);
            e.igniteForSeconds(4.0f);
        }
    });
    public static final BlockFlatTile.CollisionEffect SMITE = FlatTileEffects.livingEffect(e -> {
        if (e.getType().is(EntityTypeTags.UNDEAD)) {
            e.hurt(e.level().damageSources().generic(), 12.0f);
        }
    });
    public static final BlockFlatTile.CollisionEffect BANE = FlatTileEffects.livingEffect(e -> {
        if (e.getType().is(EntityTypeTags.ARTHROPOD)) {
            e.hurt(e.level().damageSources().generic(), 12.0f);
            e.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 3));
        }
    });
    public static final BlockFlatTile.CollisionEffect ANCHOR = (state, world, pos, entity) -> {
        LivingEntity living;
        if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).isCrouching() && !(living instanceof Player)) {
            Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            BlockPos offset = pos.relative(direction.getOpposite(), 5);
            living.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3((double)((float)offset.getX() + 0.5f), (double)((float)offset.getY() + 1.5f), (double)((float)offset.getZ() + 0.5f)));
            entity.setPos((double)((float)pos.getX() + 0.5f), (double)pos.getY() + 0.0625, (double)((float)pos.getZ() + 0.5f));
        }
    };

    private static BlockFlatTile.CollisionEffect statusEffect(Holder<MobEffect> effect, int duration, int amplifier) {
        return FlatTileEffects.livingEffect(living -> living.addEffect(new MobEffectInstance(effect, duration, amplifier)));
    }

    private static BlockFlatTile.CollisionEffect livingEffect(Consumer<LivingEntity> effect) {
        return (s, w, p, e) -> {
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                effect.accept(living);
            }
        };
    }

    private static DamageSource getSource(Level level, ResourceKey<DamageType> id) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        Holder.Reference damage = registry.getHolderOrThrow(id);
        return new DamageSource((Holder)damage);
    }
}

