/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public record NameStyle(ResourceLocation fontID, Optional<DyeColor> color) {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"darkutils", (String)"name_style");
    public static final CachedSupplier<DataComponentType<NameStyle>> COMPONENT = CachedSupplier.of((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (ResourceLocation)ID).cast();
    public static final MapCodec<NameStyle> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("font").forGetter(NameStyle::fontID), (App)DyeColor.CODEC.optionalFieldOf("color").forGetter(NameStyle::color)).apply((Applicative)instance, NameStyle::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, NameStyle> STREAM = StreamCodec.of((buf, val) -> {
        buf.writeResourceLocation(val.fontID);
        buf.writeOptional(val.color, (StreamEncoder)DyeColor.STREAM_CODEC);
    }, buf -> {
        ResourceLocation font = buf.readResourceLocation();
        Optional color = buf.readOptional((StreamDecoder)DyeColor.STREAM_CODEC);
        return new NameStyle(font, color);
    });
}

