package net.darkhax.darkutilities.common.recipe;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.darkutilities.common.Constants;
import net.darkhax.darkutilities.common.component.NameStyle;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8059;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9697;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SmithingFontNameRecipe implements class_8059 {

    public static final class_2960 RECIPE_ID = class_2960.method_60655(Constants.MOD_ID, "smithing_font_name");
    public static final CachedSupplier<class_1865<SmithingFontNameRecipe>> SERIALIZER = CachedSupplier.of(class_7923.field_41189, RECIPE_ID).cast();

    private static final HashMap<class_6862<class_1792>, class_1767> COLOR_MAP = class_156.method_656(() -> {
        final HashMap<class_6862<class_1792>, class_1767> map = new HashMap<>();
        for (class_1767 color : class_1767.values()) {
            map.put(class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("c", "dyes/" + color.method_7792())), color);
        }
        return map;
    });

    public static Optional<class_1767> getDyeColor(class_1799 stack) {
        if (stack.method_7909() instanceof class_1769 dye) {
            return Optional.of(dye.method_7802());
        }
        for (Map.Entry<class_6862<class_1792>, class_1767> entry : COLOR_MAP.entrySet()) {
            if (stack.method_31573(entry.getKey())) {
                return Optional.ofNullable(entry.getValue());
            }
        }
        return Optional.empty();
    }

    final class_1856 template;
    final class_2960 fontID;

    public SmithingFontNameRecipe(class_1856 template, class_2960 fontID) {
        this.template = template;
        this.fontID = fontID;
    }

    @Override
    public boolean matches(class_9697 input, class_1937 level) {
        return !input.comp_2678().method_7960() && this.template.method_8093(input.comp_2677()) && (input.comp_2679().method_7960() || getDyeColor(input.comp_2679()).isPresent());
    }

    @Override
    public class_1799 assemble(class_9697 input, class_7225.class_7874 registries) {
        final Optional<class_1767> color = getDyeColor(input.comp_2679());
        final class_1799 output = input.comp_2678().method_7972();
        output.method_57379(NameStyle.COMPONENT.get(), new NameStyle(this.fontID, color));
        return output;
    }

    @Override
    public class_1799 method_8110(class_7225.class_7874 registries) {
        return class_1802.field_8448.method_7854();
    }

    @Override
    public boolean method_48453(class_1799 stack) {
        return this.template.method_8093(stack);
    }

    @Override
    public boolean method_48454(class_1799 stack) {
        return true;
    }

    @Override
    public boolean method_30029(class_1799 stack) {
        return stack.method_7960() || getDyeColor(stack) != null;
    }

    @Override
    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    @Override
    public boolean method_31584() {
        return this.template.method_8103();
    }

    public static class Serializer implements class_1865<SmithingFontNameRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<SmithingFontNameRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                class_1856.field_46095.fieldOf("template").forGetter(r -> r.template),
                class_2960.field_25139.fieldOf("font").forGetter(r -> r.fontID)
        ).apply(instance, SmithingFontNameRecipe::new));
        public static final class_9139<class_9129, SmithingFontNameRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SmithingFontNameRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, SmithingFontNameRecipe> method_56104() {
            return STREAM_CODEC;
        }

        private static SmithingFontNameRecipe fromNetwork(class_9129 buffer) {
            final class_1856 template = class_1856.field_48355.decode(buffer);
            final class_2960 fontID = buffer.method_10810();
            return new SmithingFontNameRecipe(template, fontID);
        }

        private static void toNetwork(class_9129 buffer, SmithingFontNameRecipe recipe) {
            class_1856.field_48355.encode(buffer, recipe.template);
            buffer.method_10812(recipe.fontID);
        }
    }
}