/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.flatblocks;

import java.util.function.Consumer;
import net.darkhax.darkutilities.features.flatblocks.BlockFlatTile;
import net.darkhax.darkutilities.features.flatblocks.CollisionEffectPush;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class FlatTileEffects {
    private static final ResourceKey<DamageType> FAKE_PLAYER_DAMAGE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)new ResourceLocation("bookshelf", "fake_player"));
    public static final BlockFlatTile.CollisionEffect PUSH_WEAK = new CollisionEffectPush(0.06);
    public static final BlockFlatTile.CollisionEffect PUSH_NORMAL = new CollisionEffectPush(0.3);
    public static final BlockFlatTile.CollisionEffect PUSH_STRONG = new CollisionEffectPush(1.5);
    public static final BlockFlatTile.CollisionEffect PUSH_ULTRA = new CollisionEffectPush(7.5);
    public static final BlockFlatTile.CollisionEffect DAMAGE_GENERIC = FlatTileEffects.livingEffect(e -> e.hurt(e.level().damageSources().generic(), 6.0f));
    public static final BlockFlatTile.CollisionEffect DAMAGE_MAIM = FlatTileEffects.livingEffect(e -> {
        if (e.getHealth() >= 2.0f) {
            e.hurt(e.level().damageSources().generic(), 1.0f);
        }
    });
    public static final BlockFlatTile.CollisionEffect DAMAGE_PLAYER = FlatTileEffects.livingEffect(e -> e.hurt(FlatTileEffects.getSource(e.level(), FAKE_PLAYER_DAMAGE), 6.0f));
    public static final BlockFlatTile.CollisionEffect SLOWNESS = FlatTileEffects.statusEffect(MobEffects.MOVEMENT_SLOWDOWN, 100, 1);
    public static final BlockFlatTile.CollisionEffect FATIGUE = FlatTileEffects.statusEffect(MobEffects.DIG_SLOWDOWN, 100, 1);
    public static final BlockFlatTile.CollisionEffect DARKNESS = FlatTileEffects.statusEffect(MobEffects.BLINDNESS, 100, 1);
    public static final BlockFlatTile.CollisionEffect HUNGER = FlatTileEffects.statusEffect(MobEffects.HUNGER, 100, 0);
    public static final BlockFlatTile.CollisionEffect WEAKNESS = FlatTileEffects.statusEffect(MobEffects.WEAKNESS, 100, 0);
    public static final BlockFlatTile.CollisionEffect POISON = FlatTileEffects.statusEffect(MobEffects.POISON, 100, 0);
    public static final BlockFlatTile.CollisionEffect WITHER = FlatTileEffects.statusEffect(MobEffects.WITHER, 100, 0);
    public static final BlockFlatTile.CollisionEffect GLOWING = FlatTileEffects.statusEffect(MobEffects.GLOWING, 500, 1);
    public static final BlockFlatTile.CollisionEffect LEVITATION = FlatTileEffects.statusEffect(MobEffects.LEVITATION, 100, 1);
    public static final BlockFlatTile.CollisionEffect UNLUCK = FlatTileEffects.statusEffect(MobEffects.UNLUCK, 666, 1);
    public static final BlockFlatTile.CollisionEffect SLOWFALL = FlatTileEffects.statusEffect(MobEffects.SLOW_FALLING, 100, 1);
    public static final BlockFlatTile.CollisionEffect OMEN = FlatTileEffects.statusEffect(MobEffects.BAD_OMEN, 500, 0);
    public static final BlockFlatTile.CollisionEffect FROST = FlatTileEffects.livingEffect(e -> {
        if (e.canFreeze()) {
            e.hurt(e.level().damageSources().freeze(), 1.0f);
            int existingFrostTicks = e.getTicksFrozen();
            e.setTicksFrozen(Math.min(existingFrostTicks + 20, 80));
        }
    });
    public static final BlockFlatTile.CollisionEffect FLAME = FlatTileEffects.livingEffect(e -> {
        if (!e.fireImmune()) {
            e.hurt(e.level().damageSources().inFire(), 1.0f);
            e.setSecondsOnFire(4);
        }
    });

    private static BlockFlatTile.CollisionEffect statusEffect(MobEffect effect, int duration, int amplifier) {
        return FlatTileEffects.livingEffect(living -> living.addEffect(new MobEffectInstance(effect, duration, amplifier)));
    }

    private static BlockFlatTile.CollisionEffect livingEffect(Consumer<LivingEntity> effect) {
        return (s, w, p, e) -> {
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                effect.accept(living);
            }
        };
    }

    private static DamageSource getSource(Level level, ResourceKey<DamageType> id) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        Holder.Reference damage = registry.getHolderOrThrow(id);
        return new DamageSource((Holder)damage);
    }
}

