/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.flatblocks;

import net.darkhax.darkutilities.features.flatblocks.BlockFlatTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockFlatTileRotatable
extends BlockFlatTile {
    public BlockFlatTileRotatable() {
        this(BLOCK_PROPERTIES, null);
    }

    public BlockFlatTileRotatable(BlockFlatTile.CollisionEffect collisionEffect) {
        this(BLOCK_PROPERTIES, collisionEffect);
    }

    public BlockFlatTileRotatable(BlockBehaviour.Properties properties, BlockFlatTile.CollisionEffect collisionEffect) {
        super(properties, collisionEffect);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.isCrouching()) {
            world.setBlockAndUpdate(pos, this.rotate(state, Rotation.CLOCKWISE_90));
            return InteractionResult.SUCCESS;
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placedState = super.getStateForPlacement(context);
        if (placedState != null) {
            for (Direction facing : context.getNearestLookingDirections()) {
                if (!facing.getAxis().isHorizontal()) continue;
                return (BlockState)placedState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
            }
        }
        return placedState;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }
}

